/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime.cache.config;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hiforce.lattice.model.config.BusinessConfig;
import org.hiforce.lattice.model.config.ReadonlyBusinessConfig;
import org.hiforce.lattice.runtime.cache.LatticeCache;

public class BusinessConfigCache
implements LatticeCache {
    private static BusinessConfigCache instance;
    private final List<BusinessConfig> businessConfigs = Lists.newArrayList();

    private BusinessConfigCache() {
    }

    public static BusinessConfigCache getInstance() {
        if (null == instance) {
            instance = new BusinessConfigCache();
        }
        return instance;
    }

    @Override
    public void init() {
    }

    @Override
    public void clear() {
        this.businessConfigs.clear();
    }

    public void addBusinessConfigs(List<BusinessConfig> configs) {
        this.businessConfigs.addAll(configs);
    }

    public void removeBusinessConfig(String bizCode) {
        this.businessConfigs.removeIf(p -> !p.isAutoBuild() && StringUtils.equals((CharSequence)bizCode, (CharSequence)p.getBizCode()));
    }

    public BusinessConfig getBusinessConfigByBizCode(String bizCode) {
        BusinessConfig config = this.businessConfigs.stream().filter(p -> StringUtils.equals((CharSequence)bizCode, (CharSequence)p.getBizCode())).findFirst().orElse(null);
        if (null == config) {
            return null;
        }
        return new ReadonlyBusinessConfig(config.getBizCode(), config.getPriority(), config.getProducts(), config.getExtensions());
    }

    public List<BusinessConfig> getBusinessConfigs() {
        return this.businessConfigs;
    }
}

