/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime.ability.cache;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.hiforce.lattice.annotation.model.ScanSkipAnnotation;
import org.hiforce.lattice.model.ability.IBusinessExt;
import org.hiforce.lattice.model.ability.cache.IBusinessExtCache;
import org.hiforce.lattice.runtime.cache.LatticeCache;
import org.hiforce.lattice.runtime.utils.LatticeBeanUtils;
import org.hiforce.lattice.utils.BusinessExtUtils;
import org.hiforce.lattice.utils.LatticeAnnotationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusinessExtCache
implements IBusinessExtCache,
LatticeCache {
    private static final Logger log = LoggerFactory.getLogger(BusinessExtCache.class);
    private static BusinessExtCache instance;
    private static final Object lock;
    private static final Table<Class<?>, ExtKey, IBusinessExt> BIZ_EXT_TABLE;

    private BusinessExtCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BusinessExtCache getInstance() {
        if (null == instance) {
            Object object = lock;
            synchronized (object) {
                if (null == instance) {
                    instance = new BusinessExtCache();
                }
            }
        }
        return instance;
    }

    @Override
    public void init() {
    }

    @Override
    public void clear() {
        BIZ_EXT_TABLE.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBusinessExt getCachedBusinessExt(IBusinessExt businessExt, String extCode, String scenario) {
        scenario = StringUtils.isEmpty((CharSequence)scenario) ? "None#" : scenario;
        ExtKey extKey = new ExtKey(scenario, extCode);
        IBusinessExt found = (IBusinessExt)BIZ_EXT_TABLE.get(businessExt.getClass(), (Object)extKey);
        if (null != found) {
            return found;
        }
        Class<?> clazz = businessExt.getClass();
        synchronized (clazz) {
            IBusinessExt point = (IBusinessExt)BIZ_EXT_TABLE.get(businessExt.getClass(), (Object)extKey);
            if (point != null) {
                return point;
            }
            point = this.findSubBusinessExtViaExtCode(businessExt, extCode);
            if (point != null) {
                LatticeBeanUtils.autowireBean(point);
                BIZ_EXT_TABLE.put(businessExt.getClass(), (Object)extKey, (Object)point);
            }
            return point;
        }
    }

    public List<IBusinessExt> getAllSubBusinessExt(IBusinessExt businessExt) {
        ArrayList children = Lists.newArrayList();
        try {
            for (Method method : businessExt.getClass().getMethods()) {
                ScanSkipAnnotation scanSkip;
                if (!ClassUtils.isAssignable(method.getReturnType(), IBusinessExt.class) || null != (scanSkip = LatticeAnnotationUtils.getScanSkipAnnotation((Method)method))) continue;
                try {
                    method.setAccessible(true);
                    IBusinessExt subBusinessExt = (IBusinessExt)method.invoke((Object)businessExt, new Object[0]);
                    if (null == subBusinessExt) continue;
                    boolean b = true;
                    for (IBusinessExt p : children) {
                        if (!this.isSubBusinessClassMatched(p, subBusinessExt)) continue;
                        b = false;
                        break;
                    }
                    if (!b) continue;
                    children.add(subBusinessExt);
                }
                catch (Throwable th) {
                    log.warn(th.getMessage(), th);
                }
            }
        }
        catch (Throwable th) {
            log.warn(th.getMessage(), th);
        }
        return children;
    }

    private boolean isSubBusinessClassMatched(IBusinessExt child, IBusinessExt businessExt) {
        if (null == child || null == businessExt) {
            return false;
        }
        return child.getClass().equals(businessExt.getClass());
    }

    private IBusinessExt findSubBusinessExtViaExtCode(IBusinessExt businessExt, String extCode) {
        if (StringUtils.isEmpty((CharSequence)extCode)) {
            return null;
        }
        boolean isMatch = BusinessExtUtils.supportedExtCodes((IBusinessExt)businessExt).contains(extCode);
        if (!isMatch) {
            return null;
        }
        for (IBusinessExt facade : businessExt.getAllSubBusinessExt()) {
            IBusinessExt extension = this.findSubBusinessExtViaExtCode(facade, extCode);
            if (null == extension) continue;
            return extension;
        }
        return businessExt;
    }

    static {
        lock = new Object();
        BIZ_EXT_TABLE = HashBasedTable.create();
    }

    static class ExtKey {
        private final String scenario;
        private final String extCode;

        public ExtKey(String scenario, String extCode) {
            this.scenario = scenario;
            this.extCode = extCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExtKey key = (ExtKey)o;
            if (StringUtils.isNotEmpty((CharSequence)this.scenario) ? !StringUtils.equals((CharSequence)this.scenario, (CharSequence)key.scenario) : StringUtils.isNotEmpty((CharSequence)key.scenario)) {
                return false;
            }
            return Objects.equals(this.extCode, key.extCode);
        }

        public int hashCode() {
            int result = this.scenario != null ? this.scenario.hashCode() : 0;
            result = 31 * result + (this.extCode != null ? this.extCode.hashCode() : 0);
            return result;
        }
    }
}

