/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime.cache.ability;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.hiforce.lattice.annotation.model.AbilityAnnotation;
import org.hiforce.lattice.model.register.AbilitySpec;
import org.hiforce.lattice.runtime.cache.LatticeCache;
import org.hiforce.lattice.runtime.cache.key.ExtensionRunnerCacheKey;

public class AbilityCache
implements LatticeCache {
    private static AbilityCache instance;
    private final ConcurrentMap<String, AbilitySpec> ABILITY_SPEC_CACHE = new ConcurrentHashMap<String, AbilitySpec>(120);
    private final Map<Class<?>, Map<Long, Object>> ABILITY_RUNNER_CACHE = Maps.newConcurrentMap();

    private AbilityCache() {
    }

    public static AbilityCache getInstance() {
        if (null == instance) {
            instance = new AbilityCache();
        }
        return instance;
    }

    @Override
    public void init() {
    }

    @Override
    public void clear() {
        this.ABILITY_SPEC_CACHE.clear();
        this.ABILITY_RUNNER_CACHE.clear();
    }

    public void doCacheExtensionRunner(Class<?> abilityClass, ExtensionRunnerCacheKey key, Object runner) {
        Map<Long, Object> cache = this.ABILITY_RUNNER_CACHE.get(abilityClass);
        if (MapUtils.isEmpty(cache)) {
            cache = new ConcurrentHashMap<Long, Object>(200);
            this.ABILITY_RUNNER_CACHE.put(abilityClass, cache);
        }
        cache.put(key.getUniqueId(), runner);
    }

    public Object getCachedExtensionRunner(Class<?> abilityClass, ExtensionRunnerCacheKey key) {
        Map<Long, Object> cache = this.ABILITY_RUNNER_CACHE.get(abilityClass);
        if (null == cache) {
            return null;
        }
        return cache.get(key.getUniqueId());
    }

    public AbilitySpec doCacheAbilitySpec(AbilityAnnotation ability, Class<?> targetClass) {
        String abilityCode = StringUtils.isEmpty((CharSequence)ability.getCode()) ? targetClass.getName() : ability.getCode();
        AbilitySpec abilitySpec = this.getAbilitySpecEntry(abilityCode);
        if (null == abilitySpec) {
            abilitySpec = AbilitySpec.of((String)abilityCode, (String)ability.getName(), (String)ability.getDesc());
            abilitySpec.setAbilityClass(targetClass);
            if (StringUtils.isNotEmpty((CharSequence)ability.getParent())) {
                abilitySpec.setParentCode(ability.getParent());
            }
            return this.doCacheObjectAbilitySpec(abilityCode, abilitySpec);
        }
        return abilitySpec;
    }

    public AbilitySpec getAbilitySpecEntry(String key) {
        if (key == null) {
            return null;
        }
        return (AbilitySpec)this.ABILITY_SPEC_CACHE.get(key);
    }

    public AbilitySpec doCacheObjectAbilitySpec(String key, AbilitySpec obj) {
        this.ABILITY_SPEC_CACHE.put(key, obj);
        return obj;
    }

    public Collection<AbilitySpec> getAllCachedAbilities() {
        return this.ABILITY_SPEC_CACHE.values();
    }
}

