/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime.spi;

import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.collections4.CollectionUtils;
import org.hiforce.lattice.model.ability.IAbility;
import org.hiforce.lattice.runtime.ability.execute.RunnerCollection;
import org.hiforce.lattice.runtime.spi.IRunnerCollectionBuilder;
import org.hiforce.lattice.spi.classloader.CustomClassLoaderSpi;
import org.hiforce.lattice.spi.config.BusinessConfigLoadSpi;

public class LatticeRuntimeSpiFactory {
    private static volatile LatticeRuntimeSpiFactory instance;
    private IRunnerCollectionBuilder runnerCollectionBuilder;
    private List<BusinessConfigLoadSpi> businessConfigLoads;
    private List<CustomClassLoaderSpi> customClassLoaders;

    private LatticeRuntimeSpiFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LatticeRuntimeSpiFactory getInstance() {
        if (null != instance) return instance;
        Class<LatticeRuntimeSpiFactory> clazz = LatticeRuntimeSpiFactory.class;
        synchronized (LatticeRuntimeSpiFactory.class) {
            if (null != instance) return instance;
            instance = new LatticeRuntimeSpiFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public List<CustomClassLoaderSpi> getCustomClassLoaders() {
        if (null == this.customClassLoaders) {
            this.customClassLoaders = this.getCustomServiceProviders(CustomClassLoaderSpi.class);
        }
        return this.customClassLoaders;
    }

    public List<BusinessConfigLoadSpi> getBusinessConfigLoads() {
        if (null == this.businessConfigLoads) {
            this.businessConfigLoads = this.getCustomServiceProviders(BusinessConfigLoadSpi.class);
        }
        if (CollectionUtils.isNotEmpty(this.businessConfigLoads)) {
            this.businessConfigLoads.forEach(p -> p.setClassLoader(this.getClassLoader()));
            this.businessConfigLoads.sort(Comparator.comparingInt(BusinessConfigLoadSpi::getPriority));
        }
        return this.businessConfigLoads;
    }

    public <T> List<T> getCustomServiceProviders(Class<T> spiClass) {
        ServiceLoader<T> serializers = ServiceLoader.load(spiClass, this.getClassLoader());
        return StreamSupport.stream(serializers.spliterator(), false).distinct().collect(Collectors.toList());
    }

    private ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRunnerCollectionBuilder getRunnerCollectionBuilder() {
        if (null != this.runnerCollectionBuilder) {
            return this.runnerCollectionBuilder;
        }
        Class<LatticeRuntimeSpiFactory> clazz = LatticeRuntimeSpiFactory.class;
        synchronized (LatticeRuntimeSpiFactory.class) {
            if (null == this.runnerCollectionBuilder) {
                ServiceLoader<IRunnerCollectionBuilder> serializers = ServiceLoader.load(IRunnerCollectionBuilder.class, this.getClassLoader());
                Optional<1> serializer = StreamSupport.stream(serializers.spliterator(), false).findFirst();
                this.runnerCollectionBuilder = serializer.orElse(new IRunnerCollectionBuilder(){

                    @Override
                    public boolean isSupport(IAbility ability, String extensionCode) {
                        return false;
                    }

                    public RunnerCollection buildCustomRunnerCollection(IAbility ability, String extensionCode) {
                        return RunnerCollection.of(ability.getContext().getBizObject(), Lists.newArrayList(), RunnerCollection.ACCEPT_ALL);
                    }
                });
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.runnerCollectionBuilder;
        }
    }
}

