/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime.cache.exension;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.hiforce.lattice.model.register.ExtensionSpec;
import org.hiforce.lattice.runtime.Lattice;
import org.hiforce.lattice.runtime.cache.LatticeCache;
import org.hiforce.lattice.runtime.cache.index.ExtensionIndex;

public class ExtensionCache
implements LatticeCache {
    private static ExtensionCache instance;
    private final Map<String, ExtensionSpec> extensionSpecCache = Maps.newConcurrentMap();
    private final ExtensionIndex extensionIndex = new ExtensionIndex();

    private ExtensionCache() {
    }

    public static ExtensionCache getInstance() {
        if (null == instance) {
            instance = new ExtensionCache();
        }
        return instance;
    }

    public void doCacheExtensionSpec(Set<ExtensionSpec> extensionSet) {
        extensionSet.forEach(p -> this.extensionSpecCache.put(p.getCode(), (ExtensionSpec)p));
    }

    public ExtensionSpec getExtensionSpecByCode(String extCode) {
        return this.extensionSpecCache.get(extCode);
    }

    @Override
    public void init() {
        List<ExtensionSpec> extensions = Lattice.getInstance().getAllRegisteredAbilities().stream().flatMap(p -> p.getAbilityInstances().stream()).flatMap(p -> p.getExtensions().stream()).collect(Collectors.toList());
        extensions.forEach(p -> this.extensionIndex.put(p.getCode().intern(), p.getInternalId(), p));
    }

    @Override
    public void clear() {
        this.extensionIndex.clear();
        this.extensionSpecCache.clear();
    }

    public ExtensionIndex getExtensionIndex() {
        return this.extensionIndex;
    }
}

