/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime.cache.key;

import java.util.Objects;
import org.hiforce.lattice.model.register.TemplateSpec;
import org.hiforce.lattice.runtime.cache.key.BaseObjectCacheKey;

public class ExtensionInvokeCacheKey
extends BaseObjectCacheKey {
    private final String templateCode;
    private final String scenario;
    private final String extensionCode;
    private int hash;

    public ExtensionInvokeCacheKey(String scenario, TemplateSpec template, String extCode) {
        this.scenario = scenario;
        this.templateCode = template.getCode();
        this.extensionCode = extCode;
        this.setTemplateIndex(template.getInternalId());
        this.buildObjectCacheUniqueId();
    }

    @Override
    public boolean customEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtensionInvokeCacheKey key = (ExtensionInvokeCacheKey)o;
        if (this.scenario != null ? !this.scenario.equals(key.getScenario()) : key.scenario != null) {
            return false;
        }
        if (!Objects.equals(this.templateCode, key.templateCode)) {
            return false;
        }
        return this.getExtensionCode() != null ? this.getExtensionCode().equals(key.getExtensionCode()) : key.getExtensionCode() == null;
    }

    public int hashCode() {
        if (this.hash == 0) {
            int result = this.scenario != null ? this.scenario.hashCode() : 0;
            result = 31 * result + (this.templateCode != null ? this.templateCode.hashCode() : 0);
            this.hash = result = 31 * result + (this.getExtensionCode() != null ? this.getExtensionCode().hashCode() : 0);
        }
        return this.hash;
    }

    @Override
    public String getBizCode() {
        return null;
    }

    @Override
    public boolean isSupportCustomization() {
        return false;
    }

    @Override
    public boolean isOnlyProduct() {
        return false;
    }

    @Override
    public boolean validateIndex() {
        return null != this.getTemplateCode() && null != this.getExtensionCode();
    }

    @Override
    public String getTemplateCode() {
        return this.templateCode;
    }

    @Override
    public String getScenario() {
        return this.scenario;
    }

    @Override
    public String getExtensionCode() {
        return this.extensionCode;
    }
}

