/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime.ability.register;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.hiforce.lattice.annotation.model.AbilityAnnotation;
import org.hiforce.lattice.annotation.model.ExtensionAnnotation;
import org.hiforce.lattice.annotation.model.ProtocolType;
import org.hiforce.lattice.annotation.model.ReduceType;
import org.hiforce.lattice.exception.LatticeRuntimeException;
import org.hiforce.lattice.message.Message;
import org.hiforce.lattice.model.ability.IAbility;
import org.hiforce.lattice.model.register.AbilityInstSpec;
import org.hiforce.lattice.model.register.AbilitySpec;
import org.hiforce.lattice.model.register.ExtensionSpec;
import org.hiforce.lattice.runtime.Lattice;
import org.hiforce.lattice.runtime.ability.register.AbilityBuildRequest;
import org.hiforce.lattice.runtime.ability.register.AbilityInstBuildResult;
import org.hiforce.lattice.runtime.cache.ability.AbilityCache;
import org.hiforce.lattice.runtime.utils.LatticeBeanUtils;
import org.hiforce.lattice.spi.LatticeAnnotationSpiFactory;
import org.hiforce.lattice.spi.annotation.AbilityAnnotationParser;
import org.hiforce.lattice.utils.LatticeAnnotationUtils;
import org.hiforce.lattice.utils.LatticeClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;

public class AbilityRegister {
    private static final Logger log = LoggerFactory.getLogger(AbilityRegister.class);
    private static final ThreadLocal<ClassLoader> CLASS_LOADER_THREAD_LOCAL = new ThreadLocal();
    private static AbilityRegister instance;

    private AbilityRegister() {
    }

    public static AbilityRegister getInstance() {
        if (null == instance) {
            instance = new AbilityRegister();
        }
        return instance;
    }

    public List<AbilitySpec> register(AbilityBuildRequest regDTO) {
        ArrayList<AbilitySpec> abilitySpecList = new ArrayList<AbilitySpec>();
        for (Class currentClass : regDTO.getClassSet()) {
            Pair<AbilityAnnotation, Class<?>> pair = this.findAbilityAnnotationAndAbilityClass(currentClass);
            if (null == pair) continue;
            AbilityAnnotation ability = (AbilityAnnotation)pair.getLeft();
            Class targetClass = (Class)pair.getRight();
            if (null == ability || null != regDTO.getParent() && !ability.getParent().equals(regDTO.getParent().getCode())) continue;
            AbilitySpec abilitySpec = AbilityCache.getInstance().doCacheAbilitySpec(ability, targetClass);
            abilitySpecList.add(abilitySpec);
            abilitySpec.addAbilityInstance(this.scanAbilityInstance(abilitySpec, regDTO.getClassSet()));
        }
        return abilitySpecList;
    }

    private Pair<AbilityAnnotation, Class<?>> findAbilityAnnotationAndAbilityClass(Class<?> currentClass) {
        List parsers = LatticeAnnotationSpiFactory.getInstance().getAbilityAnnotationParsers();
        for (AbilityAnnotationParser parser : parsers) {
            Object annotation = currentClass.getDeclaredAnnotation(parser.getAnnotationClass());
            if (null == annotation) continue;
            AbilityAnnotation annotationInfo = parser.buildAnnotationInfo(annotation, currentClass);
            return Pair.of((Object)annotationInfo, currentClass);
        }
        return null;
    }

    public synchronized List<AbilityInstSpec> scanAbilityInstance(AbilitySpec abilitySpec, Collection<Class> classSet) {
        ArrayList<AbilityInstSpec> abilityInstanceSpecList = new ArrayList<AbilityInstSpec>(this.registerAbilityInstances(abilitySpec, classSet));
        abilityInstanceSpecList.sort(Comparator.comparingInt(AbilityInstSpec::getPriority));
        return abilityInstanceSpecList;
    }

    private List<AbilityInstSpec> registerAbilityInstances(AbilitySpec abilitySpec, Collection<Class> classSet) {
        ArrayList<AbilityInstSpec> instanceSpecs = new ArrayList<AbilityInstSpec>();
        for (Class targetClass : classSet) {
            if (Modifier.isAbstract(targetClass.getModifiers()) || Modifier.isInterface(targetClass.getModifiers()) || !LatticeClassUtils.isSubClassOf((Class)targetClass, (Class)abilitySpec.getAbilityClass())) continue;
            AbilityInstBuildResult result = this.innerRegisterAbilityInstance(abilitySpec, targetClass);
            if (!result.isSuccess() && !result.isRegistered()) {
                Message message = null == result.getMessage() ? Message.code((String)"LATTICE-CORE-RT-0001", (Object[])new Object[]{targetClass.getName(), "not clear"}) : result.getMessage();
                throw new LatticeRuntimeException(message);
            }
            AbilityInstSpec abilityInstanceSpec = result.getInstanceSpec();
            if (null == abilityInstanceSpec) continue;
            instanceSpecs.add(abilityInstanceSpec);
        }
        return instanceSpecs;
    }

    private AbilityInstBuildResult innerRegisterAbilityInstance(AbilitySpec abilitySpec, Class<?> instanceClass) {
        AbilityInstSpec abilityInstanceSpec;
        IAbility originAbility;
        Object beanViaClass = LatticeBeanUtils.getAndCreateSpringBeanViaClass(instanceClass, new Object[]{null});
        if (beanViaClass instanceof IAbility) {
            IAbility ability = (IAbility)beanViaClass;
            if (AopUtils.isAopProxy((Object)ability)) {
                Class originCls = AopUtils.getTargetClass((Object)ability);
                try {
                    Object curObject = LatticeBeanUtils.getAndCreateSpringBeanViaClass(originCls, new Object[]{null});
                    originAbility = (IAbility)curObject;
                }
                catch (Exception e) {
                    return AbilityInstBuildResult.failed(Message.code((String)"LATTICE-CORE-RT-0002", (Object[])new Object[]{originCls.getName()}));
                }
            } else {
                originAbility = ability;
            }
        } else {
            return AbilityInstBuildResult.failed(Message.code((String)"LATTICE-CORE-RT-0002", (Object[])new Object[]{instanceClass.getName()}));
        }
        if (this.isAbilityInstanceRegistered(abilitySpec, originAbility)) {
            return AbilityInstBuildResult.registered();
        }
        AbilityInstBuildResult result = this.buildAbilityInstanceSpec(abilitySpec, originAbility, instanceClass);
        if (result.isSuccess() && null != (abilityInstanceSpec = result.getInstanceSpec())) {
            Lattice.getInstance().getRuntimeCache().getExtensionCache().doCacheExtensionSpec(abilityInstanceSpec.getExtensions());
        }
        return result;
    }

    private boolean isAbilityInstanceRegistered(AbilitySpec abilitySpec, IAbility<?> ability) {
        return abilitySpec.getAbilityInstSpecMap().values().stream().anyMatch(p -> p.getCode().equals(ability.getInstanceCode()));
    }

    private AbilityInstBuildResult buildAbilityInstanceSpec(AbilitySpec abilitySpec, IAbility<?> instance, Class<?> instanceClass) {
        try {
            AbilityInstSpec instanceDesc = new AbilityInstSpec();
            instanceDesc.setInstanceClass(instanceClass.getName());
            instanceDesc.setCode(instance.getInstanceCode());
            instanceDesc.setName(instanceClass.getSimpleName());
            instanceDesc.getExtensions().addAll(this.scanAbilityExtensions(instance, abilitySpec));
            abilitySpec.addAbilityInstance(instanceDesc);
            return AbilityInstBuildResult.success(instanceDesc);
        }
        catch (LatticeRuntimeException ex) {
            throw ex;
        }
        catch (Exception e) {
            return AbilityInstBuildResult.failed(Message.code((String)"LATTICE-CORE-RT-0003", (Object[])new Object[]{instanceClass, e.getMessage()}));
        }
    }

    private Set<ExtensionSpec> scanAbilityExtensions(IAbility<?> ability, AbilitySpec abilitySpec) {
        try {
            Class<?> returnType = ability.getDefaultRealization().getClass();
            if (returnType.isAnonymousClass() || returnType.isInterface()) {
                throw new LatticeRuntimeException("LATTICE-CORE-RT-0022", new Object[]{returnType.getName()});
            }
            return new HashSet<ExtensionSpec>(this.scanAbilityExtensions(returnType, abilitySpec));
        }
        catch (LatticeRuntimeException ex) {
            throw ex;
        }
        catch (Throwable th) {
            Message message = Message.code((String)"LATTICE-CORE-RT-0004", (Object[])new Object[]{ability.getClass().getName(), th.getMessage()});
            log.error(message.getText(), th);
            throw new LatticeRuntimeException(message);
        }
    }

    private Set<ExtensionSpec> scanAbilityExtensions(Class<?> itfClass, AbilitySpec abilitySpec) {
        Method[] methods;
        HashSet<ExtensionSpec> extensionSpecList = new HashSet<ExtensionSpec>();
        for (Method method : methods = itfClass.getMethods()) {
            ExtensionSpec extensionSpec;
            ExtensionAnnotation annotation = LatticeAnnotationUtils.getExtensionAnnotation((Method)method);
            if (null == annotation || null == (extensionSpec = this.buildExtensionPointSpec(annotation, abilitySpec, itfClass, method))) continue;
            extensionSpecList.add(extensionSpec);
        }
        return extensionSpecList;
    }

    public ExtensionSpec buildExtensionPointSpec(ExtensionAnnotation annotation, AbilitySpec abilitySpec, Class<?> itfClass, Method method) {
        if (null == annotation) {
            return null;
        }
        return this.buildExtensionPointSpec(abilitySpec, annotation.getCode(), annotation.getName(), annotation.getDesc(), itfClass, method, annotation.getReduceType(), annotation.getProtocolType());
    }

    private ExtensionSpec buildExtensionPointSpec(AbilitySpec abilitySpec, String extensionCode, String extensionName, String extensionDesc, Class<?> itfClass, Method method, ReduceType reduceType, ProtocolType protocolType) {
        ExtensionSpec extensionSpec = ExtensionSpec.of((Method)method, (String)abilitySpec.getCode(), (String)extensionCode, (String)extensionName, (String)extensionDesc);
        extensionSpec.setReduceType(reduceType);
        extensionSpec.setProtocolType(protocolType);
        extensionSpec.setItfClass(itfClass);
        return extensionSpec;
    }
}

