/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.hiforce.lattice.cache.ILatticeRuntimeCache;
import org.hiforce.lattice.cache.LatticeCacheFactory;
import org.hiforce.lattice.exception.LatticeRuntimeException;
import org.hiforce.lattice.message.Message;
import org.hiforce.lattice.message.MessageCode;
import org.hiforce.lattice.model.ability.IAbility;
import org.hiforce.lattice.model.ability.IBusinessExt;
import org.hiforce.lattice.model.business.BusinessTemplate;
import org.hiforce.lattice.model.business.IBizObject;
import org.hiforce.lattice.model.business.IBusiness;
import org.hiforce.lattice.model.business.IProduct;
import org.hiforce.lattice.model.business.IUseCase;
import org.hiforce.lattice.model.business.TemplateType;
import org.hiforce.lattice.model.config.BusinessConfig;
import org.hiforce.lattice.model.config.ExtPriority;
import org.hiforce.lattice.model.config.ExtPriorityConfig;
import org.hiforce.lattice.model.config.ProductConfig;
import org.hiforce.lattice.model.config.ReadonlyBusinessConfig;
import org.hiforce.lattice.model.config.builder.BusinessConfigBuilder;
import org.hiforce.lattice.model.register.AbilitySpec;
import org.hiforce.lattice.model.register.BaseSpec;
import org.hiforce.lattice.model.register.BusinessSpec;
import org.hiforce.lattice.model.register.ProductSpec;
import org.hiforce.lattice.model.register.RealizationSpec;
import org.hiforce.lattice.model.register.TemplateSpec;
import org.hiforce.lattice.model.register.UseCaseSpec;
import org.hiforce.lattice.model.scenario.ScenarioRequest;
import org.hiforce.lattice.runtime.ability.creator.DefaultAbilityCreator;
import org.hiforce.lattice.runtime.ability.register.AbilityBuildRequest;
import org.hiforce.lattice.runtime.ability.register.AbilityRegister;
import org.hiforce.lattice.runtime.ability.register.TemplateRegister;
import org.hiforce.lattice.runtime.cache.LatticeRuntimeCache;
import org.hiforce.lattice.runtime.cache.ability.AbilityCache;
import org.hiforce.lattice.runtime.cache.config.BusinessConfigCache;
import org.hiforce.lattice.runtime.spi.LatticeRuntimeSpiFactory;
import org.hiforce.lattice.runtime.utils.ClassLoaderUtil;
import org.hiforce.lattice.runtime.utils.ClassPathScanHandler;
import org.hiforce.lattice.spi.classloader.CustomClassLoaderSpi;
import org.hiforce.lattice.spi.classloader.LatticeClassLoader;
import org.hiforce.lattice.utils.BizCodeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Lattice {
    private static final Logger log = LoggerFactory.getLogger(Lattice.class);
    private static Lattice instance;
    private String uuid = UUID.randomUUID().toString();
    private boolean initialized = false;
    private boolean simpleMode = false;
    private LatticeClassLoader latticeClassLoader;
    private final List<AbilitySpec> registeredAbilities = Lists.newArrayList();
    private final LatticeRuntimeCache runtimeCache = (LatticeRuntimeCache)LatticeCacheFactory.getInstance().getRuntimeCache((ILatticeRuntimeCache)new LatticeRuntimeCache());

    private Lattice() {
    }

    public AbilitySpec getAbilitySpecByCode(String code) {
        return this.registeredAbilities.stream().filter(p -> StringUtils.equals((CharSequence)code, (CharSequence)p.getCode())).findFirst().orElse(null);
    }

    public static Lattice getInstance() {
        if (null == instance) {
            instance = new Lattice();
        }
        return instance;
    }

    public final void start() {
        this.initLatticeClassLoader();
        this.registerAbilities();
        this.registerRealizations();
        this.registerBusinesses();
        this.registerUseCases();
        this.registerProducts();
        this.buildBusinessConfig();
        this.initLatticeCache();
        this.initialized = true;
    }

    public void initLatticeClassLoader() {
        this.latticeClassLoader = new LatticeClassLoader(Lattice.class.getClassLoader());
        List<CustomClassLoaderSpi> customClassLoaders = LatticeRuntimeSpiFactory.getInstance().getCustomClassLoaders();
        this.latticeClassLoader.getCustomLoaders().addAll(customClassLoaders.stream().map(CustomClassLoaderSpi::getCustomClassLoader).filter(Objects::nonNull).collect(Collectors.toList()));
        Thread.currentThread().setContextClassLoader((ClassLoader)this.latticeClassLoader);
    }

    public final void clear() {
        this.runtimeCache.clear();
        this.registeredAbilities.clear();
        TemplateRegister.getInstance().clear();
        AbilityCache.getInstance().clear();
        this.initialized = false;
    }

    public void reload() {
        this.clear();
        this.start();
    }

    private void initLatticeCache() {
        this.getRuntimeCache().init();
        this.initErrorMessageCode();
        ClassPathScanHandler.clearCache();
    }

    private void initErrorMessageCode() {
        Message.clean();
        MessageCode.init();
    }

    public BusinessConfig getBusinessConfigByBizCode(String bizCode) {
        BusinessConfig config = BusinessConfigCache.getInstance().getBusinessConfigByBizCode(bizCode);
        if (null == config) {
            return null;
        }
        return new ReadonlyBusinessConfig(config.getBizCode(), config.getPriority(), config.getProducts(), config.getExtensions());
    }

    private void buildBusinessConfig() {
        List bizCodes = Lattice.getInstance().getAllRegisteredBusinesses().stream().map(BaseSpec::getCode).collect(Collectors.toList());
        List<BusinessConfig> configs = LatticeRuntimeSpiFactory.getInstance().getBusinessConfigLoads().stream().flatMap(p -> p.loadBusinessConfigs(bizCodes).stream()).collect(Collectors.toList());
        BusinessConfigCache.getInstance().addBusinessConfigs(configs);
        if (this.isSimpleMode()) {
            this.autoBuildBusinessConfig();
        }
    }

    private void autoBuildUseCaseExtPriorityConfig(BusinessConfig businessConfig, Map<String, ExtPriorityConfig> priorityMap) {
        priorityMap.forEach((key, value) -> {
            ExtPriorityConfig priorityConfig = businessConfig.getExtPriorityConfigByExtCode(key);
            if (null == priorityConfig) {
                businessConfig.getExtensions().add(value);
            } else {
                ArrayList newList = Lists.newArrayList();
                newList.addAll(value.getPriorities());
                newList.addAll(priorityConfig.getPriorities());
                priorityConfig.setPriorities((List)newList);
            }
        });
    }

    private Map<String, ExtPriorityConfig> buildUseCaseExtPriorityConfigMap() {
        HashMap extPriorityConfigMap = Maps.newHashMap();
        this.getAllRegisteredUseCases().forEach(p -> {
            for (RealizationSpec realizationSpec : p.getRealizations()) {
                for (String extCode : realizationSpec.getExtensionCodes()) {
                    ExtPriorityConfig config = (ExtPriorityConfig)extPriorityConfigMap.get(extCode);
                    if (null == config) {
                        config = new ExtPriorityConfig(extCode);
                        extPriorityConfigMap.put(extCode, config);
                    }
                    config.getPriorities().add(ExtPriority.of((String)p.getCode(), (TemplateType)p.getType()));
                }
            }
        });
        return extPriorityConfigMap;
    }

    public void addBusinessConfig(BusinessConfig config) {
        if (null == config) {
            throw new LatticeRuntimeException("LATTICE-CORE-RT-0015", new Object[0]);
        }
        Message message = this.checkBusinessConfig(config);
        if (null != message) {
            throw new LatticeRuntimeException(message);
        }
        BusinessConfigCache.getInstance().getBusinessConfigs().stream().filter(p -> StringUtils.equals((CharSequence)config.getBizCode(), (CharSequence)p.getBizCode())).findFirst().ifPresent(BusinessConfigCache.getInstance().getBusinessConfigs()::remove);
        BusinessConfigCache.getInstance().getBusinessConfigs().add(config);
    }

    private Message checkBusinessConfig(BusinessConfig config) {
        if (StringUtils.isEmpty((CharSequence)config.getBizCode())) {
            return Message.code((String)"LATTICE-CORE-RT-0014", (Object[])new Object[0]);
        }
        return null;
    }

    public BusinessConfig autoAddAndBuildBusinessConfig(BusinessSpec businessSpec) {
        List productConfigs = this.getAllRegisteredProducts().stream().map(this::buildProductConfig).collect(Collectors.toList());
        BusinessConfig businessConfig = BusinessConfigCache.getInstance().getBusinessConfigs().stream().filter(p -> StringUtils.equals((CharSequence)p.getBizCode(), (CharSequence)businessSpec.getCode())).findFirst().orElse(null);
        if (null != businessConfig) {
            return businessConfig;
        }
        List priorityConfigs = businessSpec.getRealizations().stream().flatMap(p -> this.autoBuildPriorityConfig(businessSpec, (RealizationSpec)p).stream()).filter(Objects::nonNull).collect(Collectors.toList());
        businessConfig = BusinessConfigBuilder.builder().priority(businessSpec.getPriority()).bizCode(businessSpec.getCode()).install(productConfigs).extension(priorityConfigs).build();
        businessConfig.setAutoBuild(true);
        BusinessConfigCache.getInstance().getBusinessConfigs().add(businessConfig);
        BusinessConfigCache.getInstance().getBusinessConfigs().forEach(p -> this.autoBuildUseCaseExtPriorityConfig((BusinessConfig)p, this.buildUseCaseExtPriorityConfigMap()));
        BusinessConfigCache.getInstance().getBusinessConfigs().sort(Comparator.comparingInt(BusinessConfig::getPriority));
        return businessConfig;
    }

    public List<BusinessConfig> getBusinessConfigs() {
        return BusinessConfigCache.getInstance().getBusinessConfigs();
    }

    private void autoBuildBusinessConfig() {
        for (BusinessSpec businessSpec : this.getAllRegisteredBusinesses()) {
            this.autoAddAndBuildBusinessConfig(businessSpec);
        }
    }

    private void autoMakeupPriorityConfig(BusinessConfig businessConfig, List<ProductSpec> products) {
        HashMap priorityConfigHashMap = Maps.newHashMap();
        for (ProductSpec spec : products) {
            List extCodes = spec.getRealizations().stream().flatMap(p -> p.getExtensionCodes().stream()).filter(arg_0 -> ((BusinessConfig)businessConfig).notContainExtCode(arg_0)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(extCodes)) continue;
            for (String extCode : extCodes) {
                ExtPriorityConfig priorityConfig = (ExtPriorityConfig)priorityConfigHashMap.get(extCode);
                if (null == priorityConfig) {
                    priorityConfig = new ExtPriorityConfig();
                    priorityConfig.setExtCode(extCode);
                    priorityConfigHashMap.put(extCode, priorityConfig);
                }
                priorityConfig.getPriorities().add(ExtPriority.of((String)spec.getCode(), (TemplateType)TemplateType.PRODUCT));
            }
        }
        priorityConfigHashMap.values().forEach(p -> businessConfig.getExtensions().add(p));
    }

    private List<ExtPriorityConfig> autoBuildPriorityConfig(BusinessSpec business, RealizationSpec realization) {
        ArrayList configs = Lists.newArrayList();
        for (String extCode : realization.getExtensionCodes()) {
            List products = this.getAllRegisteredProducts().stream().filter(p -> p.getRealizations().stream().anyMatch(real -> real.getExtensionCodes().contains(extCode))).collect(Collectors.toList());
            ExtPriorityConfig config = new ExtPriorityConfig();
            config.setExtCode(extCode);
            config.getPriorities().add(ExtPriority.of((String)business.getCode(), (TemplateType)TemplateType.BUSINESS));
            configs.add(config);
            if (CollectionUtils.isEmpty(products)) continue;
            config.getPriorities().addAll(0, products.stream().map(this::buildExtPriority).collect(Collectors.toList()));
        }
        return configs;
    }

    private ExtPriority buildExtPriority(ProductSpec productSpec) {
        return ExtPriority.of((String)productSpec.getCode(), (TemplateType)TemplateType.PRODUCT);
    }

    private ProductConfig buildProductConfig(ProductSpec productSpec) {
        return ProductConfig.of((String)productSpec.getCode());
    }

    public Collection<AbilitySpec> getAllRegisteredAbilities() {
        return this.getRuntimeCache().getAbilityCache().getAllCachedAbilities();
    }

    public List<UseCaseSpec> getAllRegisteredUseCases() {
        return TemplateRegister.getInstance().getUseCases();
    }

    public List<ProductSpec> getAllRegisteredProducts() {
        return TemplateRegister.getInstance().getProducts();
    }

    public List<BusinessSpec> getAllRegisteredBusinesses() {
        return TemplateRegister.getInstance().getBusinesses();
    }

    public List<RealizationSpec> getAllRegisteredRealizations() {
        return TemplateRegister.getInstance().getRealizations();
    }

    public BusinessSpec getRegisteredBusinessByCode(String code) {
        return TemplateRegister.getInstance().getBusinesses().stream().filter(p -> StringUtils.equals((CharSequence)code, (CharSequence)p.getCode())).findFirst().orElse(null);
    }

    public TemplateSpec getTemplateSpec(String code, TemplateType type) {
        if (type == TemplateType.BUSINESS) {
            return this.getRegisteredBusinessByCode(code);
        }
        if (type == TemplateType.PRODUCT) {
            return this.getRegisteredProductByCode(code);
        }
        if (type == TemplateType.USE_CASE) {
            return this.getRegisteredUseCaseByCode(code);
        }
        return null;
    }

    public ProductSpec getRegisteredProductByCode(String code) {
        return TemplateRegister.getInstance().getProducts().stream().filter(p -> StringUtils.equals((CharSequence)code, (CharSequence)p.getCode())).findFirst().orElse(null);
    }

    public UseCaseSpec getRegisteredUseCaseByCode(String code) {
        return TemplateRegister.getInstance().getUseCases().stream().filter(p -> StringUtils.equals((CharSequence)code, (CharSequence)p.getCode())).findFirst().orElse(null);
    }

    public static List<String> getServiceProviderValues(String spiClassName, ClassLoader originLoader) {
        ArrayList classNames = Lists.newArrayList();
        try {
            ArrayList classLoaders = Lists.newArrayList((Object[])new ClassLoader[]{null == originLoader ? Thread.currentThread().getContextClassLoader() : originLoader});
            for (ClassLoader classLoader : classLoaders) {
                Enumeration<URL> enumeration = classLoader.getResources("META-INF/services/" + spiClassName);
                while (enumeration.hasMoreElements()) {
                    URL url = enumeration.nextElement();
                    classNames.addAll(Lattice.loadSpiFileContent(url));
                }
            }
        }
        catch (IOException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        return classNames;
    }

    private static Class<?> loadClass(String className, ClassLoader classLoader) {
        if (StringUtils.isEmpty((CharSequence)className)) {
            return null;
        }
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Set<Class> getServiceProviderClasses(String spiClassName, ClassLoader classLoader) {
        LatticeClassLoader originLoader = Lattice.getInstance().getLatticeClassLoader();
        List<String> classNames = Lattice.getServiceProviderValues(spiClassName, (ClassLoader)originLoader);
        return classNames.stream().filter(StringUtils::isNotEmpty).map(p -> Lattice.loadClass(p, classLoader)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static Set<Class> getServiceProviderClasses(String spiClassName) {
        LatticeClassLoader originLoader = Lattice.getInstance().getLatticeClassLoader();
        Object classLoader = null == originLoader ? Thread.currentThread().getContextClassLoader() : originLoader;
        return Lattice.getServiceProviderClasses(spiClassName, (ClassLoader)classLoader);
    }

    private static List<String> loadSpiFileContent(URL url) {
        ArrayList<String> contentList = new ArrayList<String>();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));){
            String eachLine;
            while (StringUtils.isNotBlank((CharSequence)(eachLine = bufferedReader.readLine()))) {
                eachLine = eachLine.trim();
                contentList.add(eachLine);
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        return contentList;
    }

    private void registerRealizations() {
        Set<Class> classSet = Lattice.getServiceProviderClasses(IBusinessExt.class.getName());
        TemplateRegister.getInstance().registerRealizations(classSet);
    }

    private void registerAbilities() {
        Set<Class> abilityClasses = Lattice.getServiceProviderClasses(IAbility.class.getName());
        this.registeredAbilities.addAll(AbilityRegister.getInstance().register(new AbilityBuildRequest(null, this.mergeAbilityInstancePackage(abilityClasses))));
    }

    private void registerBusinesses() {
        Set<Class> classSet = Lattice.getServiceProviderClasses(IBusiness.class.getName());
        TemplateRegister.getInstance().registerBusinesses(classSet);
    }

    private void registerProducts() {
        Set<Class> classSet = Lattice.getServiceProviderClasses(IProduct.class.getName());
        TemplateRegister.getInstance().registerProducts(classSet);
    }

    private void registerUseCases() {
        Set<Class> classSet = Lattice.getServiceProviderClasses(IUseCase.class.getName());
        TemplateRegister.getInstance().registerUseCases(classSet);
    }

    private Set<Class> mergeAbilityInstancePackage(Set<Class> abilityClasses) {
        HashSet classesSet = Sets.newHashSet(abilityClasses);
        Set packageSet = abilityClasses.stream().map(p -> p.getPackage().getName()).collect(Collectors.toSet());
        for (String pkg : packageSet) {
            classesSet.addAll(ClassLoaderUtil.scanLatticeClasses(pkg));
        }
        return classesSet;
    }

    public RealizationSpec getRealizationSpecByCode(String code) {
        return TemplateRegister.getInstance().getRealizations().stream().filter(p -> BizCodeUtils.isCodesMatched((String)p.getCode(), (String)code)).findFirst().orElse(null);
    }

    public List<RealizationSpec> getAllRealizations() {
        return TemplateRegister.getInstance().getRealizations();
    }

    public BusinessTemplate getFirstMatchedBusiness(ScenarioRequest request) {
        return TemplateRegister.getInstance().getFirstMatchedBusiness(request);
    }

    public static <Ability extends IAbility> List<Ability> getAllAbilities(Class<?> abilityClass, IBizObject target) {
        if (null == abilityClass) {
            throw new LatticeRuntimeException("LATTICE-CORE-RT-0025", new Object[0]);
        }
        return Lattice.getAllAbilities(abilityClass.getName(), target);
    }

    public static <Ability extends IAbility> List<Ability> getAllAbilities(String abilityCode, IBizObject target) {
        DefaultAbilityCreator creator = new DefaultAbilityCreator(abilityCode, target);
        List abilityList = creator.getAllAbilityInstancesWithCache();
        if (abilityList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IAbility> abilities = new ArrayList<IAbility>(abilityList.size());
        for (IAbility ability : abilityList) {
            boolean supportChecking = ability.supportChecking();
            if (!supportChecking) continue;
            abilities.add(ability);
        }
        return abilities;
    }

    public static <Ability extends IAbility> Ability getFirstMatchedAbility(Class<?> abilityClass, IBizObject target) {
        if (null == abilityClass) {
            throw new LatticeRuntimeException("LATTICE-CORE-RT-0025", new Object[0]);
        }
        return Lattice.getFirstMatchedAbility(abilityClass.getName(), target);
    }

    public static <Ability extends IAbility> Ability getFirstMatchedAbility(String abilityCode, IBizObject target) {
        DefaultAbilityCreator creator = new DefaultAbilityCreator(abilityCode, target);
        List domainAbilitySet = creator.getAllAbilityInstancesWithCache();
        if (domainAbilitySet.isEmpty()) {
            return null;
        }
        for (IAbility ability : domainAbilitySet) {
            boolean supportChecking = ability.supportChecking();
            if (!supportChecking) continue;
            return (Ability)ability;
        }
        return null;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isSimpleMode() {
        return this.simpleMode;
    }

    public void setSimpleMode(boolean simpleMode) {
        this.simpleMode = simpleMode;
    }

    public LatticeClassLoader getLatticeClassLoader() {
        return this.latticeClassLoader;
    }

    public void setLatticeClassLoader(LatticeClassLoader latticeClassLoader) {
        this.latticeClassLoader = latticeClassLoader;
    }

    public List<AbilitySpec> getRegisteredAbilities() {
        return this.registeredAbilities;
    }

    public LatticeRuntimeCache getRuntimeCache() {
        return this.runtimeCache;
    }
}

