/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime.cache;

import com.google.auto.service.AutoService;
import org.apache.commons.lang3.StringUtils;
import org.hiforce.lattice.cache.ILatticeRuntimeCache;
import org.hiforce.lattice.runtime.ability.cache.AbilityInstCache;
import org.hiforce.lattice.runtime.ability.cache.BusinessExtCache;
import org.hiforce.lattice.runtime.ability.register.TemplateRegister;
import org.hiforce.lattice.runtime.cache.LatticeCache;
import org.hiforce.lattice.runtime.cache.ability.AbilityCache;
import org.hiforce.lattice.runtime.cache.config.BusinessConfigCache;
import org.hiforce.lattice.runtime.cache.exension.ExtensionCache;
import org.hiforce.lattice.runtime.cache.exension.ExtensionInvokeCache;
import org.hiforce.lattice.runtime.cache.index.TemplateIndex;

@AutoService(value={ILatticeRuntimeCache.class})
public class LatticeRuntimeCache
implements ILatticeRuntimeCache,
LatticeCache {
    private final TemplateIndex templateIndex = TemplateIndex.getInstance();
    private final ExtensionCache extensionCache = ExtensionCache.getInstance();
    private final AbilityCache abilityCache = AbilityCache.getInstance();
    private final BusinessConfigCache businessConfigCache = BusinessConfigCache.getInstance();
    private final ExtensionInvokeCache invokeCache = ExtensionInvokeCache.getInstance();
    private final BusinessExtCache businessExtCache = BusinessExtCache.getInstance();

    public synchronized void clearProductCache(String code) {
        TemplateRegister.getInstance().getProducts().removeIf(p -> StringUtils.equals((CharSequence)p.getCode(), (CharSequence)code));
        TemplateRegister.getInstance().getRealizations().removeIf(p -> StringUtils.equals((CharSequence)p.getCode(), (CharSequence)code));
        TemplateIndex.getInstance().remove(code);
        ExtensionInvokeCache.getInstance().clear();
        BusinessExtCache.getInstance().clear();
        AbilityCache.getInstance().clear();
    }

    public synchronized void clearBusinessCache(String bizCode) {
        TemplateRegister.getInstance().getBusinesses().removeIf(p -> StringUtils.equals((CharSequence)p.getCode(), (CharSequence)bizCode));
        TemplateRegister.getInstance().getRealizations().removeIf(p -> StringUtils.equals((CharSequence)p.getCode(), (CharSequence)bizCode));
        TemplateIndex.getInstance().remove(bizCode);
        ExtensionInvokeCache.getInstance().clear();
        BusinessConfigCache.getInstance().removeBusinessConfig(bizCode);
        BusinessExtCache.getInstance().clear();
        AbilityCache.getInstance().clear();
    }

    @Override
    public synchronized void init() {
        this.getAbilityCache().init();
        this.getExtensionCache().init();
        this.getTemplateIndex().init();
        this.getInvokeCache().init();
        this.getBusinessConfigCache().init();
        this.getBusinessExtCache().init();
        AbilityInstCache.getInstance().init();
    }

    @Override
    public synchronized void clear() {
        this.getTemplateIndex().clear();
        this.getExtensionCache().clear();
        this.getAbilityCache().clear();
        this.getInvokeCache().clear();
        this.getBusinessConfigCache().clear();
        this.getBusinessExtCache().clear();
        AbilityInstCache.getInstance().clear();
    }

    public TemplateIndex getTemplateIndex() {
        return this.templateIndex;
    }

    public ExtensionCache getExtensionCache() {
        return this.extensionCache;
    }

    public AbilityCache getAbilityCache() {
        return this.abilityCache;
    }

    public BusinessConfigCache getBusinessConfigCache() {
        return this.businessConfigCache;
    }

    public ExtensionInvokeCache getInvokeCache() {
        return this.invokeCache;
    }

    public BusinessExtCache getBusinessExtCache() {
        return this.businessExtCache;
    }
}

