/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime.cache.key;

import org.apache.commons.lang3.StringUtils;
import org.hiforce.lattice.runtime.Lattice;
import org.hiforce.lattice.runtime.cache.LatticeRuntimeCache;

public abstract class BaseObjectCacheKey {
    private static final int templateCodeLen = 5;
    private static final int supportCustomBitLen = 1;
    private static final int scenarioBitLen = 2;
    private static final int bizCodeBitLen = 4;
    private static final int extCodeBitLen = 6;
    private static final int extCodeStart = 0;
    private static final int bizCodeStart = 6;
    private static final int scenarioStart = 10;
    private static final int supportCustomStart = 8;
    private static final int templateStart = 7;
    private static final int productStart = 12;
    private static final long[] uniqueIdStarts = new long[13];
    private static final Long NO_INDEX = -1L;
    protected Long uniqueId;
    private Long bizCodeIndex;
    private Long templateIndex;
    private Long extCodeIndex;
    private Long scenarioIndex;

    public abstract String getBizCode();

    public abstract String getTemplateCode();

    public abstract String getExtensionCode();

    public abstract String getScenario();

    public abstract boolean isSupportCustomization();

    public abstract boolean isOnlyProduct();

    public abstract boolean validateIndex();

    public abstract boolean customEquals(Object var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseObjectCacheKey that = (BaseObjectCacheKey)o;
        if (NO_INDEX.equals(this.uniqueId)) {
            return this.customEquals(that);
        }
        return this.uniqueId.longValue() == that.uniqueId.longValue();
    }

    protected void generateUniqueId() {
        if (this.getUniqueId() != null && this.getUniqueId() > 0L) {
            return;
        }
        if (!this.validateIndex()) {
            this.uniqueId = NO_INDEX;
            return;
        }
        long customIndex = this.isSupportCustomization() ? 1L : 0L;
        long onlyProductIndex = this.isOnlyProduct() ? 1L : 0L;
        long uniqueId = onlyProductIndex * uniqueIdStarts[12] + (null == this.templateIndex ? 0L : this.templateIndex) * uniqueIdStarts[7] + customIndex * uniqueIdStarts[8] + (null == this.scenarioIndex ? 0L : this.scenarioIndex) * uniqueIdStarts[10] + (null == this.bizCodeIndex ? 0L : this.bizCodeIndex) * uniqueIdStarts[6] + (null == this.extCodeIndex ? 0L : this.extCodeIndex) * uniqueIdStarts[0];
        this.setUniqueId(uniqueId);
    }

    protected void buildObjectCacheUniqueId() {
        if (this.getUniqueId() != null && this.getUniqueId() > 0L) {
            return;
        }
        LatticeRuntimeCache runtimeCache = Lattice.getInstance().getRuntimeCache();
        if (null == this.bizCodeIndex) {
            Long l = this.bizCodeIndex = null == this.getBizCode() ? null : (Long)runtimeCache.getTemplateIndex().getSecondKeyViaFirstKey(this.getBizCode());
        }
        if (null == this.extCodeIndex) {
            Long l = this.extCodeIndex = null == this.getExtensionCode() ? null : (Long)runtimeCache.getExtensionCache().getExtensionIndex().getSecondKeyViaFirstKey(this.getExtensionCode());
        }
        if (null == this.scenarioIndex) {
            Long scenario;
            this.scenarioIndex = StringUtils.isEmpty((CharSequence)this.getScenario()) ? Long.valueOf(0L) : Long.valueOf((scenario = runtimeCache.getInvokeCache().getScenarioIndex(this.getScenario())) == null ? 0L : scenario);
        }
        if (null == this.templateIndex || this.templateIndex <= 0L) {
            this.templateIndex = null == this.getTemplateCode() ? null : (Long)runtimeCache.getTemplateIndex().getSecondKeyViaFirstKey(this.getTemplateCode());
        }
        this.generateUniqueId();
    }

    public Long getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.uniqueId = uniqueId;
    }

    public Long getBizCodeIndex() {
        return this.bizCodeIndex;
    }

    public void setBizCodeIndex(Long bizCodeIndex) {
        this.bizCodeIndex = bizCodeIndex;
    }

    public Long getTemplateIndex() {
        return this.templateIndex;
    }

    public void setTemplateIndex(Long templateIndex) {
        this.templateIndex = templateIndex;
    }

    public Long getExtCodeIndex() {
        return this.extCodeIndex;
    }

    public void setExtCodeIndex(Long extCodeIndex) {
        this.extCodeIndex = extCodeIndex;
    }

    public Long getScenarioIndex() {
        return this.scenarioIndex;
    }

    public void setScenarioIndex(Long scenarioIndex) {
        this.scenarioIndex = scenarioIndex;
    }

    static {
        for (int i = 0; i < uniqueIdStarts.length; ++i) {
            BaseObjectCacheKey.uniqueIdStarts[i] = (long)Math.pow(10.0, i);
        }
    }
}

