/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime.utils;

import java.lang.reflect.Constructor;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.hiforce.lattice.runtime.utils.SpringAnnotationResult;
import org.hiforce.lattice.runtime.utils.SpringApplicationContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;

public class LatticeBeanUtils {
    private static final Logger log = LoggerFactory.getLogger(LatticeBeanUtils.class);

    public static void autowireBean(Object object) {
        ApplicationContext context = LatticeBeanUtils.findApplicationContext(object.getClass().getClassLoader());
        if (context != null) {
            try {
                context.getAutowireCapableBeanFactory().autowireBean(object);
            }
            catch (Throwable e) {
                log.warn("[Lattice]Failed to autowireBean " + object.getClass().getName(), e);
            }
        }
    }

    public static ApplicationContext findApplicationContext(ClassLoader classLoader) {
        return SpringApplicationContextHolder.getContext();
    }

    public static <T> T getAndCreateSpringBeanViaClass(Class<?> beanClass, Object ... values) {
        if (null == beanClass) {
            return null;
        }
        try {
            Object t;
            SpringAnnotationResult result = LatticeBeanUtils.getSpringAnnotationResult(beanClass);
            if (result.isHasAnnotation()) {
                Object t2 = t = StringUtils.isEmpty((CharSequence)result.getValue()) ? SpringApplicationContextHolder.getSpringBean(beanClass) : SpringApplicationContextHolder.getSpringBean(result.getValue());
                if (null != t) {
                    return t;
                }
            }
            if (null != (t = SpringApplicationContextHolder.getSpringBean(StringUtils.uncapitalize((String)beanClass.getSimpleName())))) {
                return t;
            }
            return LatticeBeanUtils.createSpringBeanInstance(beanClass, values);
        }
        catch (Throwable th) {
            return LatticeBeanUtils.createSpringBeanInstance(beanClass, values);
        }
    }

    private static <T> T createSpringBeanInstance(@Nonnull Class<?> beanClass, Object ... values) {
        try {
            ApplicationContext context = SpringApplicationContextHolder.getContext();
            if (context != null) {
                return (T)context.getAutowireCapableBeanFactory().createBean(beanClass);
            }
            return (T)beanClass.newInstance();
        }
        catch (Throwable e) {
            return LatticeBeanUtils.createBeanInstance(beanClass, values);
        }
    }

    private static <T> T createBeanInstance(@Nonnull Class<?> beanClass, Object ... values) {
        try {
            try {
                if (null == values || 0 == values.length) {
                    return (T)beanClass.newInstance();
                }
            }
            catch (Exception ex) {
                Constructor constructor = LatticeBeanUtils.findFirstConstructor(beanClass);
                return LatticeBeanUtils.createBeanInstanceWithNullValues(constructor);
            }
            Constructor<?> constructor = LatticeBeanUtils.getMatchedConstructor(beanClass, values);
            if (null == constructor) {
                return null;
            }
            return (T)constructor.newInstance(values);
        }
        catch (Throwable e) {
            log.warn("[Lattice]Failed to create spring bean instance", e);
            return null;
        }
    }

    private static <T> T createBeanInstanceWithNullValues(Constructor<T> constructor) throws Exception {
        Class<?>[] paramTypes = constructor.getParameterTypes();
        Object[] values = new Object[paramTypes.length];
        return constructor.newInstance(values);
    }

    private static Constructor findFirstConstructor(Class<?> beanClass) {
        if (beanClass.getConstructors().length == 0) {
            return null;
        }
        return beanClass.getConstructors()[0];
    }

    private static Constructor<?> getMatchedConstructor(Class<?> beanClass, Object ... values) {
        for (Constructor<?> constructor : beanClass.getConstructors()) {
            if (!LatticeBeanUtils.checkConstructMatched(constructor, values)) continue;
            return constructor;
        }
        return null;
    }

    private static boolean checkConstructMatched(Constructor<?> constructor, Object ... values) {
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        if (parameterTypes.length != values.length) {
            return false;
        }
        for (int i = 0; i < values.length; ++i) {
            if (null == values[i] || ClassUtils.isAssignable(values[i].getClass(), LatticeBeanUtils.formatParamType(parameterTypes[i]))) continue;
            return false;
        }
        return true;
    }

    private static Class<?> formatParamType(Class<?> paramClass) {
        if (!paramClass.isPrimitive()) {
            return paramClass;
        }
        if (Integer.TYPE.equals(paramClass)) {
            return Integer.class;
        }
        if (Long.TYPE.equals(paramClass)) {
            return Long.class;
        }
        if (Double.TYPE.equals(paramClass)) {
            return Double.class;
        }
        if (Boolean.TYPE.equals(paramClass)) {
            return Boolean.class;
        }
        return paramClass;
    }

    private static SpringAnnotationResult getSpringAnnotationResult(Class<?> beanClass) {
        Service service = (Service)AnnotationUtils.getAnnotation(beanClass, Service.class);
        if (null != service) {
            return new SpringAnnotationResult(true, service.value());
        }
        Repository repository = (Repository)AnnotationUtils.getAnnotation(beanClass, Repository.class);
        if (null != repository) {
            return new SpringAnnotationResult(true, repository.value());
        }
        Component component = (Component)AnnotationUtils.getAnnotation(beanClass, Component.class);
        if (null != component) {
            return new SpringAnnotationResult(true, component.value());
        }
        return new SpringAnnotationResult(false, null);
    }
}

