/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime.ability.creator;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.hiforce.lattice.model.ability.IAbility;
import org.hiforce.lattice.model.business.IBizObject;
import org.hiforce.lattice.model.register.AbilityInstSpec;
import org.hiforce.lattice.model.register.AbilitySpec;
import org.hiforce.lattice.runtime.Lattice;
import org.hiforce.lattice.runtime.ability.cache.AbilityInstCache;
import org.hiforce.lattice.runtime.ability.cache.AbilityInstCacheKey;
import org.hiforce.lattice.runtime.utils.LatticeBeanUtils;

public class DefaultAbilityCreator<Ability extends IAbility> {
    private String abilityCode;
    private IBizObject target;
    private final Map<AbilityInstCacheKey, List<Ability>> abilitySelectorCache = new ConcurrentHashMap<AbilityInstCacheKey, List<Ability>>(1024);

    public DefaultAbilityCreator(String abilityCode, IBizObject target) {
        this.target = target;
        this.abilityCode = abilityCode;
    }

    public List<Ability> getAllAbilityInstancesWithCache() {
        AbilityInstCacheKey selectorCacheKey = new AbilityInstCacheKey(this.target.getBizCode(), this.abilityCode);
        List abilityList = this.abilitySelectorCache.computeIfAbsent(selectorCacheKey, key -> {
            LinkedHashSet<IAbility> abilities = new LinkedHashSet<IAbility>();
            List<Class<IAbility>> list = this.availableAbilities();
            for (Class<IAbility> instanceClass : list) {
                IAbility ability = (IAbility)LatticeBeanUtils.getAndCreateSpringBeanViaClass(instanceClass, this.target);
                if (ability == null) continue;
                abilities.add(ability);
            }
            return new ArrayList(abilities);
        });
        return abilityList;
    }

    private List<Class<IAbility>> availableAbilities() {
        List<Class<IAbility>> returnValue = AbilityInstCache.getInstance().getAbilityInstCodes(this.abilityCode);
        if (returnValue != null) {
            return returnValue;
        }
        ArrayList<Class<IAbility>> abilityClasses = new ArrayList<Class<IAbility>>(8);
        AbilitySpec abilitySpec = Lattice.getInstance().getAbilitySpecByCode(this.abilityCode);
        if (null == abilitySpec) {
            AbilityInstCache.getInstance().cacheAbilityInstanceRelation(this.abilityCode, abilityClasses);
            return abilityClasses;
        }
        Set abilityInstanceSpecList = abilitySpec.getAbilityInstances();
        ArrayList<AbilityInstSpec> result = new ArrayList<AbilityInstSpec>();
        for (AbilityInstSpec abilityInstanceSpec : abilityInstanceSpecList) {
            if (!StringUtils.isNotEmpty((CharSequence)abilityInstanceSpec.getInstanceClass())) continue;
            result.add(abilityInstanceSpec);
        }
        result.sort(Comparator.comparingInt(AbilityInstSpec::getPriority));
        for (AbilityInstSpec spec : result) {
            try {
                abilityClasses.add(Class.forName(spec.getInstanceClass()));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        AbilityInstCache.getInstance().cacheAbilityInstanceRelation(this.abilityCode, abilityClasses);
        return abilityClasses;
    }
}

