/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime.ability.cache;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hiforce.lattice.model.ability.IAbility;
import org.hiforce.lattice.runtime.cache.LatticeCache;

public class AbilityInstCache
implements LatticeCache {
    private static AbilityInstCache instance;
    private static final Object lock;
    private static final Map<String, List<Class<IAbility>>> ABILITY_INST_MAP;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AbilityInstCache getInstance() {
        if (null == instance) {
            Object object = lock;
            synchronized (object) {
                if (null == instance) {
                    instance = new AbilityInstCache();
                }
            }
        }
        return instance;
    }

    public List<Class<IAbility>> getAbilityInstCodes(String abilityCode) {
        return ABILITY_INST_MAP.get(abilityCode);
    }

    public void cacheAbilityInstanceRelation(String abilityCode, List<Class<IAbility>> instanceClasses) {
        ABILITY_INST_MAP.put(abilityCode, instanceClasses);
    }

    @Override
    public void init() {
    }

    @Override
    public void clear() {
        ABILITY_INST_MAP.clear();
    }

    static {
        lock = new Object();
        ABILITY_INST_MAP = new ConcurrentHashMap<String, List<Class<IAbility>>>();
    }
}

