/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime.ability;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.hiforce.lattice.annotation.model.AbilityAnnotation;
import org.hiforce.lattice.annotation.model.ExtensionAnnotation;
import org.hiforce.lattice.exception.LatticeRuntimeException;
import org.hiforce.lattice.message.Message;
import org.hiforce.lattice.model.ability.IAbility;
import org.hiforce.lattice.model.ability.IBusinessExt;
import org.hiforce.lattice.model.ability.execute.ExtensionCallback;
import org.hiforce.lattice.model.ability.execute.Reducer;
import org.hiforce.lattice.model.business.IBizObject;
import org.hiforce.lattice.model.context.AbilityContext;
import org.hiforce.lattice.model.register.ExtensionSpec;
import org.hiforce.lattice.runtime.Lattice;
import org.hiforce.lattice.runtime.ability.delegate.BaseLatticeAbilityDelegate;
import org.hiforce.lattice.runtime.ability.execute.ExecuteResult;
import org.hiforce.lattice.runtime.ability.execute.RunnerCollection;
import org.hiforce.lattice.runtime.ability.execute.filter.ExtensionFilter;
import org.hiforce.lattice.runtime.cache.LatticeRuntimeCache;
import org.hiforce.lattice.utils.JacksonUtils;
import org.hiforce.lattice.utils.LatticeAnnotationUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;

public abstract class BaseLatticeAbility<BusinessExt extends IBusinessExt>
implements IAbility<BusinessExt> {
    private static final Logger log = LoggerFactory.getLogger(BaseLatticeAbility.class);
    private final IBizObject bizObject;
    private final String instanceCode;
    private final BaseLatticeAbilityDelegate delegate;
    private AbilityContext context;
    private final LatticeRuntimeCache runtimeCache = Lattice.getInstance().getRuntimeCache();

    public BaseLatticeAbility(IBizObject bizObject) {
        this.bizObject = bizObject;
        this.instanceCode = this.getClass().getName();
        this.delegate = new BaseLatticeAbilityDelegate(this);
    }

    public AbilityContext getContext() {
        if (null == this.context) {
            this.context = new AbilityContext(this.bizObject);
        }
        return this.context;
    }

    public String getCode() {
        AbilityAnnotation annotation = LatticeAnnotationUtils.getAbilityAnnotation(this.getClass());
        if (null == annotation) {
            return null;
        }
        return annotation.getCode();
    }

    public <R> void handleReduceExecuteFailed(ExecuteResult<R> result) {
        log.error(result.getErrLogText());
    }

    public boolean supportChecking() {
        return true;
    }

    public boolean supportCustomization() {
        return true;
    }

    public boolean hasDefaultExtension() {
        return true;
    }

    public <T, R> R reduceExecute(ExtensionCallback<BusinessExt, T> callback, @NotNull Reducer<T, R> reducer) {
        if (!Lattice.getInstance().isInitialized()) {
            throw new LatticeRuntimeException("LATTICE-CORE-RT-0023", new Object[0]);
        }
        return this.reduceExecute(callback, reducer, ExtensionFilter.DEFAULT_FILTER);
    }

    @Deprecated
    public final <T, R> R reduceExecute(ExtensionCallback<BusinessExt, T> callback, @Nonnull Reducer<T, R> reducer, ExtensionFilter filter) {
        if (!Lattice.getInstance().isInitialized()) {
            throw new LatticeRuntimeException("LATTICE-CORE-RT-0023", new Object[0]);
        }
        ExecuteResult<R> result = this.reduceExecuteWithDetailResult(callback, reducer, filter);
        if (null == result || null == result.getResult()) {
            return null;
        }
        log.debug("[Lattice] invoke result: {}", (Object)JacksonUtils.serializeWithoutException(result));
        if (!result.isSuccess()) {
            this.handleReduceExecuteFailed(result);
            return null;
        }
        return result.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T, R> ExecuteResult<R> reduceExecuteWithDetailResult(ExtensionCallback<BusinessExt, T> callback, @Nonnull Reducer<T, R> reducer, ExtensionFilter filter) {
        if (!Lattice.getInstance().isInitialized()) {
            throw new LatticeRuntimeException("LATTICE-CORE-RT-0023", new Object[0]);
        }
        try {
            String bizCode;
            this.initAbiliinittyInvokeContext(callback);
            String extCode = this.getContext().getExtCode();
            if (StringUtils.isEmpty((CharSequence)extCode)) {
                throw new LatticeRuntimeException("LATTICE-CORE-RT-0007", new Object[0]);
            }
            if (null == this.getContext().getBizObject()) {
                ExecuteResult executeResult = ExecuteResult.failed(this.bizObject.getBizCode(), extCode, Message.code((String)"LATTICE-CORE-RT-0018", (Object[])new Object[0]));
                return executeResult;
            }
            if (this.getContext().getBizObject().getBizContext().getBizId() == null) {
                ExecuteResult executeResult = ExecuteResult.failed(this.bizObject.getBizCode(), extCode, Message.code((String)"LATTICE-CORE-RT-0019", (Object[])new Object[0]));
                return executeResult;
            }
            if (!this.supportChecking()) {
                ExecuteResult executeResult = ExecuteResult.success(this.getContext().getBizCode(), extCode, reducer.reduceName(), Message.code((String)"LATTICE-CORE-RT-0020", (Object[])new Object[]{this.getClass().getName(), Optional.ofNullable(this.getContext().getBizObject()).map(p -> p.getBizContext()).map(p -> p.getBizInfo()).orElse(this.getContext().getBizObject().getBizId().toString()), extCode}));
                return executeResult;
            }
            ExtensionSpec extensionSpec = this.getRuntimeCache().getExtensionCache().getExtensionSpecByCode(extCode);
            if (null == extensionSpec && !Lattice.getInstance().isSimpleMode()) {
                throw new LatticeRuntimeException("LATTICE-CORE-RT-0016", new Object[]{extCode});
            }
            if (null != extensionSpec && !reducer.reducerType().equals((Object)extensionSpec.getReduceType())) {
                log.warn(Message.code((String)"LATTICE-CORE-RT-0017", (Object[])new Object[]{extCode, reducer.reducerType(), extensionSpec.getReduceType()}).getText());
            }
            if (StringUtils.isEmpty((CharSequence)(bizCode = this.getContext().getBizObject().getBizCode()))) {
                throw new LatticeRuntimeException("LATTICE-CORE-RT-0008", new Object[0]);
            }
            ArrayList results = new ArrayList(16);
            RunnerCollection runnerCollection = this.delegate.loadExtensionRunners(extCode, filter);
            ExecuteResult executeResult = runnerCollection.distinct().reduceExecute(extCode, reducer, callback, results);
            return executeResult;
        }
        finally {
            this.context = null;
        }
    }

    private <T> void initAbiliinittyInvokeContext(ExtensionCallback<BusinessExt, T> callback) {
        IBusinessExt businessExt = this.getDefaultRealization();
        ArrayList extParams = Lists.newArrayList();
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(businessExt.getClass());
        enhancer.setCallback((Callback)((MethodInterceptor)(o, method, params, methodProxy) -> {
            this.getContext().setExtMethod(method);
            if (null != params) {
                for (Object p : params) {
                    extParams.add(p);
                }
            }
            this.getContext().setInvokeParams(extParams);
            ExtensionAnnotation annotation = LatticeAnnotationUtils.getExtensionAnnotation((Method)method);
            if (null == annotation) {
                log.warn("[Lattice] invoke context, failed to get annotation, method={}", (Object)method.getName());
            } else {
                this.getContext().setExtCode(annotation.getCode());
                this.getContext().setExtName(annotation.getName());
            }
            log.debug("[Lattice] invoke context, method={}, annotation=[code={}, name={}], params={}", new Object[]{method.getName(), this.getContext().getExtCode(), this.getContext().getExtName(), JacksonUtils.serializeWithoutException((Object)extParams)});
            return null;
        }));
        businessExt = (IBusinessExt)enhancer.create();
        callback.apply(businessExt);
    }

    public IBizObject getBizObject() {
        return this.bizObject;
    }

    public String getInstanceCode() {
        return this.instanceCode;
    }

    public LatticeRuntimeCache getRuntimeCache() {
        return this.runtimeCache;
    }
}

