/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime.ability.register;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hiforce.lattice.annotation.model.BusinessAnnotation;
import org.hiforce.lattice.annotation.model.ExtensionAnnotation;
import org.hiforce.lattice.annotation.model.ProductAnnotation;
import org.hiforce.lattice.annotation.model.RealizationAnnotation;
import org.hiforce.lattice.annotation.model.UseCaseAnnotation;
import org.hiforce.lattice.exception.LatticeRuntimeException;
import org.hiforce.lattice.model.ability.IBusinessExt;
import org.hiforce.lattice.model.business.BusinessTemplate;
import org.hiforce.lattice.model.register.BusinessSpec;
import org.hiforce.lattice.model.register.ExtensionSpec;
import org.hiforce.lattice.model.register.ProductSpec;
import org.hiforce.lattice.model.register.RealizationSpec;
import org.hiforce.lattice.model.register.TemplateSpec;
import org.hiforce.lattice.model.register.UseCaseSpec;
import org.hiforce.lattice.model.scenario.ScenarioRequest;
import org.hiforce.lattice.runtime.cache.index.TemplateIndex;
import org.hiforce.lattice.utils.BizCodeUtils;
import org.hiforce.lattice.utils.BusinessExtUtils;
import org.hiforce.lattice.utils.LatticeAnnotationUtils;

public class TemplateRegister {
    private static TemplateRegister instance;
    private final List<RealizationSpec> realizations = Lists.newArrayList();
    private final List<ProductSpec> products = Lists.newArrayList();
    private final List<UseCaseSpec> useCases = Lists.newArrayList();
    private final List<BusinessSpec> businesses = Lists.newArrayList();

    private TemplateRegister() {
    }

    public static TemplateRegister getInstance() {
        if (null == instance) {
            instance = new TemplateRegister();
        }
        return instance;
    }

    public BusinessTemplate getFirstMatchedBusiness(ScenarioRequest request) {
        return this.businesses.stream().map(BusinessSpec::newInstance).filter(p -> p.isEffect(request)).findFirst().orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<BusinessSpec> registerBusinesses(Set<Class> classSet) {
        ArrayList businessSpecs = Lists.newArrayList();
        Class<TemplateRegister> clazz = TemplateRegister.class;
        synchronized (TemplateRegister.class) {
            for (Class clz : classSet) {
                BusinessAnnotation annotation = LatticeAnnotationUtils.getBusinessAnnotation((Class)clz);
                if (null == annotation) continue;
                BusinessSpec businessSpec = new BusinessSpec();
                businessSpec.setBusinessClass(clz);
                businessSpec.setCode(annotation.getCode());
                businessSpec.setName(annotation.getName());
                businessSpec.setDescription(annotation.getDesc());
                businessSpec.setPriority(annotation.getPriority());
                businessSpec.getRealizations().addAll(this.realizations.stream().filter(p -> BizCodeUtils.isCodesMatched((String)p.getCode(), (String)businessSpec.getCode())).collect(Collectors.toList()));
                TemplateIndex.getInstance().addTemplateIndex((TemplateSpec)businessSpec);
                this.businesses.add(businessSpec);
                businessSpecs.add(businessSpec);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return businessSpecs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<UseCaseSpec> registerUseCases(Set<Class> classSet) {
        ArrayList useCaseSpecs = Lists.newArrayList();
        Class<TemplateRegister> clazz = TemplateRegister.class;
        synchronized (TemplateRegister.class) {
            for (Class clz : classSet) {
                UseCaseAnnotation annotation = LatticeAnnotationUtils.getUseCaseAnnotation((Class)clz);
                if (null == annotation) continue;
                UseCaseSpec spec = new UseCaseSpec();
                spec.setUseCaseClass(clz);
                spec.setCode(annotation.getCode());
                spec.setName(annotation.getName());
                spec.setDescription(annotation.getDesc());
                spec.setPriority(annotation.getPriority());
                spec.setSdk(annotation.getSdk());
                spec.getRealizations().addAll(this.realizations.stream().filter(p -> StringUtils.equals((CharSequence)p.getCode(), (CharSequence)spec.getCode())).collect(Collectors.toList()));
                try {
                    IBusinessExt businessExt = (IBusinessExt)annotation.getSdk().newInstance();
                    spec.getExtensions().addAll(this.scanBusinessExtensions(businessExt));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                this.useCases.add(spec);
                useCaseSpecs.add(spec);
            }
            this.useCases.sort(Comparator.comparingInt(TemplateSpec::getPriority));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return useCaseSpecs;
        }
    }

    private synchronized Set<ExtensionSpec> scanBusinessExtensions(IBusinessExt businessExt) {
        HashSet extensionSpecList = Sets.newHashSet();
        Method[] methods = businessExt.getClass().getMethods();
        for (Method method : methods) {
            ExtensionSpec extensionSpec;
            ExtensionAnnotation annotation = LatticeAnnotationUtils.getExtensionAnnotation((Method)method);
            if (null == annotation || null == (extensionSpec = this.buildExtensionPointSpec(annotation, method))) continue;
            extensionSpecList.add(extensionSpec);
        }
        for (IBusinessExt subBusinessExt : businessExt.getAllSubBusinessExt()) {
            extensionSpecList.addAll(this.scanBusinessExtensions(subBusinessExt));
        }
        return extensionSpecList;
    }

    private synchronized ExtensionSpec buildExtensionPointSpec(ExtensionAnnotation annotation, Method invokeMethod) {
        ExtensionSpec spec = new ExtensionSpec(invokeMethod);
        spec.setProtocolType(annotation.getProtocolType());
        spec.setCode(annotation.getCode());
        spec.setName(StringUtils.isEmpty((CharSequence)annotation.getName()) ? invokeMethod.getName() : annotation.getName());
        spec.setReduceType(annotation.getReduceType());
        spec.setDescription(annotation.getDesc());
        return spec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<ProductSpec> registerProducts(Set<Class> classSet) {
        ArrayList productSpecs = Lists.newArrayList();
        Class<TemplateRegister> clazz = TemplateRegister.class;
        synchronized (TemplateRegister.class) {
            for (Class clz : classSet) {
                ProductAnnotation annotation = LatticeAnnotationUtils.getProductAnnotation((Class)clz);
                if (null == annotation) continue;
                ProductSpec productSpec = new ProductSpec();
                productSpec.setProductClass(clz);
                productSpec.setCode(annotation.getCode());
                productSpec.setName(annotation.getName());
                productSpec.setDescription(annotation.getDesc());
                productSpec.setPriority(annotation.getPriority());
                productSpec.getRealizations().addAll(this.realizations.stream().filter(p -> StringUtils.equals((CharSequence)p.getCode(), (CharSequence)productSpec.getCode())).collect(Collectors.toList()));
                this.products.add(productSpec);
                productSpecs.add(productSpec);
            }
            this.products.sort(Comparator.comparingInt(TemplateSpec::getPriority));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return productSpecs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<RealizationSpec> registerRealizations(Set<Class> classSet) {
        ArrayList realizationSpecs = Lists.newArrayList();
        Class<TemplateRegister> clazz = TemplateRegister.class;
        synchronized (TemplateRegister.class) {
            for (Class clz : classSet) {
                RealizationAnnotation annotation = LatticeAnnotationUtils.getRealizationAnnotation((Class)clz);
                if (null == annotation) continue;
                for (String code : annotation.getCodes()) {
                    RealizationSpec spec = new RealizationSpec();
                    spec.setCode(code);
                    spec.setScenario(annotation.getScenario());
                    spec.setBusinessExtClass(annotation.getBusinessExtClass());
                    try {
                        spec.setBusinessExt((IBusinessExt)annotation.getBusinessExtClass().newInstance());
                    }
                    catch (Exception e) {
                        throw new LatticeRuntimeException("LATTICE-CORE-RT-0005", new Object[]{clz.getName()});
                    }
                    spec.getExtensionCodes().addAll(BusinessExtUtils.supportedExtCodes((IBusinessExt)spec.getBusinessExt()));
                    this.realizations.add(spec);
                    realizationSpecs.add(spec);
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return realizationSpecs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() {
        Class<TemplateRegister> clazz = TemplateRegister.class;
        synchronized (TemplateRegister.class) {
            this.realizations.clear();
            this.products.clear();
            this.useCases.clear();
            this.businesses.clear();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public List<RealizationSpec> getRealizations() {
        return this.realizations;
    }

    public List<ProductSpec> getProducts() {
        return this.products;
    }

    public List<UseCaseSpec> getUseCases() {
        return this.useCases;
    }

    public List<BusinessSpec> getBusinesses() {
        return this.businesses;
    }
}

