/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime.ability.execute.runner;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.hifforce.lattice.message.Message;
import org.hifforce.lattice.model.ability.IBusinessExt;
import org.hifforce.lattice.model.ability.execute.ExtensionCallback;
import org.hifforce.lattice.model.business.IBizObject;
import org.hiforce.lattice.runtime.ability.execute.runner.ExtensionRunner;
import org.hiforce.lattice.runtime.ability.execute.runner.ExtensionRunnerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionJavaRunner<T extends IBusinessExt, R>
extends ExtensionRunner<T, R> {
    private static final Logger log = LoggerFactory.getLogger(ExtensionJavaRunner.class);

    @Override
    public R runFirstMatched(Object abilityInstance, IBizObject bizInstance, ExtensionCallback<IBusinessExt, R> callback, ExtensionRunner.RunnerExecuteResult executeResult) {
        if (null == this.getModel()) {
            log.warn(Message.code((String)"LATTICE-CORE-RT-0009", (Object[])new Object[]{this.getExtensionCode()}).toString());
            return null;
        }
        executeResult.setExecute(true);
        executeResult.setRunnerType(this.getType());
        return (R)callback.apply((IBusinessExt)this.getModel());
    }

    public ExtensionJavaRunner(String extensionCode, int priority, T model) {
        super(extensionCode, model);
        this.setPriority(priority);
    }

    @Override
    @Nonnull
    public List<R> runAllMatched(Object abilityInstance, IBizObject bizInstance, ExtensionCallback<IBusinessExt, R> callback, ExtensionRunner.RunnerExecuteResult executeResult) {
        return Collections.singletonList(this.runFirstMatched(abilityInstance, bizInstance, callback, executeResult));
    }

    @Override
    public ExtensionRunnerType getType() {
        return ExtensionRunnerType.JAVA;
    }
}

