/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime.ability.reduce;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.CollectionUtils;
import org.hifforce.lattice.model.ability.execute.Reducer;

public class Collect<T>
extends Reducer<T, List<T>> {
    private final Predicate<T> predicate;

    public Collect(@Nonnull Predicate<T> predicate) {
        Objects.requireNonNull(predicate);
        this.predicate = predicate;
    }

    public boolean willBreak(Collection<T> elements) {
        return false;
    }

    public List<T> reduce(Collection<T> elements) {
        if (CollectionUtils.isEmpty(elements)) {
            return new ArrayList(0);
        }
        ArrayList<T> results = new ArrayList<T>(10);
        for (T element : elements) {
            if (!this.predicate.test(element)) continue;
            results.add(element);
        }
        return results;
    }

    public Predicate<T> getPredicate() {
        return this.predicate;
    }
}

