/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime.session;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.hifforce.lattice.cache.invoke.InvokeCache;
import org.hifforce.lattice.exception.LatticeRuntimeException;
import org.hifforce.lattice.model.business.IBizObject;
import org.hifforce.lattice.model.business.ProductTemplate;
import org.hifforce.lattice.model.context.BizSessionContext;
import org.hifforce.lattice.model.register.ProductSpec;
import org.hifforce.lattice.model.scenario.ScenarioRequest;
import org.hiforce.lattice.runtime.Lattice;
import org.hiforce.lattice.runtime.session.Scope;

public abstract class BizSessionScope<Resp, BizObject extends IBizObject>
extends Scope<Resp> {
    private final List<BizObject> bizObjects = Lists.newArrayList();
    private final List<ScenarioRequest> scenarioRequests = Lists.newArrayList();
    private BizSessionContext context;
    private boolean invokeCacheInit;

    public BizSessionScope(List<BizObject> bizObjects) {
        if (CollectionUtils.isEmpty(bizObjects)) {
            throw new LatticeRuntimeException("LATTICE-CORE-RT-0010", new Object[0]);
        }
        this.bizObjects.addAll(bizObjects);
    }

    public BizSessionScope(BizObject bizObject) {
        if (null == bizObject) {
            throw new LatticeRuntimeException("LATTICE-CORE-RT-0010", new Object[0]);
        }
        this.bizObjects.add(bizObject);
    }

    public abstract ScenarioRequest buildScenarioRequest(BizObject var1);

    @Override
    protected void entrance() {
        this.invokeCacheInit = InvokeCache.isThreadLocalInit();
        if (!this.invokeCacheInit) {
            InvokeCache.initInvokeCache();
        }
        this.context = (BizSessionContext)BizSessionContext.SESSION_CONTEXT_THREAD_LOCAL.get();
        InvokeCache.instance().put(BizSessionContext.class, BizSessionContext.class, (Object)this.context);
        this.initScenarioRequest();
        this.buildEffectProducts();
    }

    private void buildEffectProducts() {
        for (ScenarioRequest request : this.scenarioRequests) {
            List productSpecs = Lattice.getInstance().getAllRegisteredProducts().stream().filter(p -> this.isProductEffective((ProductSpec)p, request)).collect(Collectors.toList());
            this.context.getEffectiveProducts().put(request.getBizObject().getBizCode(), productSpecs);
        }
    }

    private boolean isProductEffective(ProductSpec productSpec, ScenarioRequest request) {
        if (null == productSpec) {
            return false;
        }
        ProductTemplate template = productSpec.createProductInstance();
        if (null == template) {
            return false;
        }
        return template.isEffect(request);
    }

    private void initScenarioRequest() {
        for (IBizObject bizObject : this.bizObjects) {
            ScenarioRequest request = this.buildScenarioRequest(bizObject);
            if (null == request) {
                throw new LatticeRuntimeException("LATTICE-CORE-RT-0011", new Object[0]);
            }
            this.scenarioRequests.add(request);
        }
    }

    @Override
    protected void exit() {
        if (!this.invokeCacheInit) {
            InvokeCache.forceClear();
        }
        BizSessionContext.SESSION_CONTEXT_THREAD_LOCAL.set(null);
        BizSessionContext.SESSION_CONTEXT_THREAD_LOCAL.remove();
    }

    @Override
    protected Scope.Entrance getEntrance() {
        return BizSessionScope.newEntrance();
    }

    public BizSessionContext getContext() {
        return this.context;
    }
}

