/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime.utils;

import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.hifforce.lattice.annotation.model.ExtensionAnnotation;
import org.hifforce.lattice.model.ability.IBusinessExt;
import org.hiforce.lattice.runtime.utils.ExtensionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusinessExtUtils {
    private static final Logger log = LoggerFactory.getLogger(BusinessExtUtils.class);
    private static final Map<Class<?>, Set<String>> CODE_MAP = new ConcurrentHashMap();

    public static Set<String> supportedExtCodes(IBusinessExt businessExt) {
        if (null == businessExt) {
            return Sets.newHashSet();
        }
        Class<?> key = businessExt.getClass();
        Set<String> result = CODE_MAP.get(key);
        if (CollectionUtils.isNotEmpty(result)) {
            return result;
        }
        Set supportedCodes = Sets.newConcurrentHashSet();
        supportedCodes.addAll(BusinessExtUtils.distinctSupportCodes(businessExt));
        try {
            for (Method method : businessExt.getClass().getMethods()) {
                ExtensionAnnotation annotation = ExtensionUtils.getExtensionAnnotation(method);
                if (null == annotation || !StringUtils.isNotEmpty((CharSequence)annotation.getCode())) continue;
                supportedCodes.add(annotation.getCode());
            }
        }
        catch (Throwable th) {
            log.warn(th.getMessage(), th);
        }
        if (null == CODE_MAP.get(key)) {
            CODE_MAP.put(key, supportedCodes);
        } else {
            CODE_MAP.get(key).addAll(supportedCodes);
        }
        return supportedCodes;
    }

    private static Set<String> distinctSupportCodes(IBusinessExt businessExt) {
        Set codes = Sets.newConcurrentHashSet();
        if (null == businessExt) {
            return Sets.newHashSet();
        }
        List subBusinessLists = businessExt.getAllSubBusinessExt();
        for (IBusinessExt subBusinessExt : subBusinessLists) {
            if (null == subBusinessExt) continue;
            codes.addAll(BusinessExtUtils.supportedExtCodes(subBusinessExt));
        }
        return codes;
    }
}

