/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.hifforce.lattice.cache.ILatticeRuntimeCache;
import org.hifforce.lattice.cache.LatticeCacheFactory;
import org.hifforce.lattice.exception.LatticeRuntimeException;
import org.hifforce.lattice.message.Message;
import org.hifforce.lattice.message.MessageCode;
import org.hifforce.lattice.model.ability.IAbility;
import org.hifforce.lattice.model.ability.IBusinessExt;
import org.hifforce.lattice.model.business.IBusiness;
import org.hifforce.lattice.model.business.IProduct;
import org.hifforce.lattice.model.business.TemplateType;
import org.hifforce.lattice.model.config.BusinessConfig;
import org.hifforce.lattice.model.config.ExtPriority;
import org.hifforce.lattice.model.config.ExtPriorityConfig;
import org.hifforce.lattice.model.config.ProductConfig;
import org.hifforce.lattice.model.config.ReadonlyBusinessConfig;
import org.hifforce.lattice.model.config.builder.BusinessConfigBuilder;
import org.hifforce.lattice.model.register.AbilitySpec;
import org.hifforce.lattice.model.register.BaseSpec;
import org.hifforce.lattice.model.register.BusinessSpec;
import org.hifforce.lattice.model.register.ProductSpec;
import org.hifforce.lattice.model.register.RealizationSpec;
import org.hifforce.lattice.utils.BizCodeUtils;
import org.hiforce.lattice.runtime.ability.register.AbilityBuildRequest;
import org.hiforce.lattice.runtime.ability.register.AbilityRegister;
import org.hiforce.lattice.runtime.ability.register.TemplateRegister;
import org.hiforce.lattice.runtime.cache.LatticeRuntimeCache;
import org.hiforce.lattice.runtime.spi.LatticeSpiFactory;
import org.hiforce.lattice.runtime.template.LatticeTemplateManager;
import org.hiforce.lattice.runtime.utils.ClassLoaderUtil;
import org.hiforce.lattice.runtime.utils.ClassPathScanHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Lattice {
    private static final Logger log = LoggerFactory.getLogger(Lattice.class);
    private static Lattice instance;
    private String uuid = UUID.randomUUID().toString();
    private boolean initialized = false;
    private boolean simpleMode = false;
    private final List<BusinessConfig> businessConfigs = Lists.newArrayList();
    private final LatticeTemplateManager templateManager = new LatticeTemplateManager();
    private final List<AbilitySpec> registeredAbilities = Lists.newArrayList();
    private final LatticeRuntimeCache latticeRuntimeCache = (LatticeRuntimeCache)LatticeCacheFactory.getInstance().getRuntimeCache((ILatticeRuntimeCache)new LatticeRuntimeCache());

    private Lattice() {
    }

    public static Lattice getInstance() {
        if (null == instance) {
            instance = new Lattice();
        }
        return instance;
    }

    public final void start() {
        this.registerAbilities();
        this.registerRealizations();
        this.registerBusinesses();
        this.registerProducts();
        this.buildBusinessConfig();
        this.initLatticeCache();
        this.initialized = true;
    }

    private void initLatticeCache() {
        this.getLatticeRuntimeCache().buildExtensionRunnerCache();
        this.initErrorMessageCode();
        ClassPathScanHandler.clearCache();
    }

    private void initErrorMessageCode() {
        Message.clean();
        MessageCode.init();
    }

    public BusinessConfig getBusinessConfigByBizCode(String bizCode) {
        BusinessConfig config = this.businessConfigs.stream().filter(p -> StringUtils.equals((CharSequence)bizCode, (CharSequence)p.getBizCode())).findFirst().orElse(null);
        if (null == config) {
            return null;
        }
        return new ReadonlyBusinessConfig(config.getBizCode(), config.getPriority(), config.getProducts(), config.getExtensions());
    }

    private void buildBusinessConfig() {
        List bizCodes = Lattice.getInstance().getAllRegisteredBusinesses().stream().map(BaseSpec::getCode).collect(Collectors.toList());
        List configs = LatticeSpiFactory.getInstance().getBusinessConfigLoads().stream().flatMap(p -> p.loadBusinessConfigs(bizCodes).stream()).collect(Collectors.toList());
        this.businessConfigs.addAll(configs);
        if (this.isSimpleMode()) {
            this.autoBuildBusinessConfig();
        }
        this.businessConfigs.sort(Comparator.comparingInt(BusinessConfig::getPriority));
    }

    public void addBusinessConfig(BusinessConfig config) {
        if (null == config) {
            throw new LatticeRuntimeException("LATTICE-CORE-RT-0015", new Object[0]);
        }
        Message message = this.checkBusinessConfig(config);
        if (null != message) {
            throw new LatticeRuntimeException(message);
        }
        this.businessConfigs.stream().filter(p -> StringUtils.equals((CharSequence)config.getBizCode(), (CharSequence)p.getBizCode())).findFirst().ifPresent(this.businessConfigs::remove);
        this.businessConfigs.add(config);
    }

    private Message checkBusinessConfig(BusinessConfig config) {
        if (StringUtils.isEmpty((CharSequence)config.getBizCode())) {
            return Message.code((String)"LATTICE-CORE-RT-0014", (Object[])new Object[0]);
        }
        return null;
    }

    private void autoBuildBusinessConfig() {
        List productConfigs = this.getAllRegisteredProducts().stream().map(this::buildProductConfig).collect(Collectors.toList());
        for (BusinessSpec businessSpec : this.getAllRegisteredBusinesses()) {
            if (this.businessConfigs.stream().anyMatch(p -> StringUtils.equals((CharSequence)p.getBizCode(), (CharSequence)businessSpec.getCode()))) continue;
            List priorityConfigs = businessSpec.getRealizations().stream().flatMap(p -> this.autoBuildPriorityConfig(businessSpec, (RealizationSpec)p).stream()).filter(Objects::nonNull).collect(Collectors.toList());
            BusinessConfig businessConfig = BusinessConfigBuilder.builder().priority(businessSpec.getPriority()).bizCode(businessSpec.getCode()).install(productConfigs).extension(priorityConfigs).build();
            this.businessConfigs.add(businessConfig);
        }
    }

    private void autoMakeupPriorityConfig(BusinessConfig businessConfig, List<ProductSpec> products) {
        HashMap priorityConfigHashMap = Maps.newHashMap();
        for (ProductSpec spec : products) {
            List extCodes = spec.getRealizations().stream().flatMap(p -> p.getExtensionCodes().stream()).filter(arg_0 -> ((BusinessConfig)businessConfig).notContainExtCode(arg_0)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(extCodes)) continue;
            for (String extCode : extCodes) {
                ExtPriorityConfig priorityConfig = (ExtPriorityConfig)priorityConfigHashMap.get(extCode);
                if (null == priorityConfig) {
                    priorityConfig = new ExtPriorityConfig();
                    priorityConfig.setExtCode(extCode);
                    priorityConfigHashMap.put(extCode, priorityConfig);
                }
                priorityConfig.getPriorities().add(ExtPriority.of((String)spec.getCode(), (TemplateType)TemplateType.PRODUCT));
            }
        }
        priorityConfigHashMap.values().forEach(p -> businessConfig.getExtensions().add(p));
    }

    private List<ExtPriorityConfig> autoBuildPriorityConfig(BusinessSpec business, RealizationSpec realization) {
        ArrayList configs = Lists.newArrayList();
        for (String extCode : realization.getExtensionCodes()) {
            List products = this.getAllRegisteredProducts().stream().filter(p -> p.getRealizations().stream().anyMatch(real -> real.getExtensionCodes().contains(extCode))).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(products)) continue;
            ArrayList extPriorities = Lists.newArrayList();
            extPriorities.addAll(products.stream().map(this::buildExtPriority).collect(Collectors.toList()));
            extPriorities.add(ExtPriority.of((String)business.getCode(), (TemplateType)TemplateType.BUSINESS));
            ExtPriorityConfig priorityConfig = new ExtPriorityConfig();
            priorityConfig.setExtCode(extCode);
            priorityConfig.getPriorities().addAll(extPriorities);
            configs.add(priorityConfig);
        }
        return configs;
    }

    private ExtPriority buildExtPriority(ProductSpec productSpec) {
        return ExtPriority.of((String)productSpec.getCode(), (TemplateType)TemplateType.PRODUCT);
    }

    private ProductConfig buildProductConfig(ProductSpec productSpec) {
        return ProductConfig.of((String)productSpec.getCode());
    }

    public Collection<AbilitySpec> getAllRegisteredAbilities() {
        return Lattice.getInstance().getLatticeRuntimeCache().getAllCachedAbilities();
    }

    public List<ProductSpec> getAllRegisteredProducts() {
        return TemplateRegister.getInstance().getProducts();
    }

    public List<BusinessSpec> getAllRegisteredBusinesses() {
        return TemplateRegister.getInstance().getBusinesses();
    }

    public List<RealizationSpec> getAllRegisteredRealizations() {
        return TemplateRegister.getInstance().getRealizations();
    }

    public BusinessSpec getRegisteredBusinessByCode(String code) {
        return TemplateRegister.getInstance().getBusinesses().stream().filter(p -> StringUtils.equals((CharSequence)code, (CharSequence)p.getCode())).findFirst().orElse(null);
    }

    public ProductSpec getRegisteredProductByCode(String code) {
        return TemplateRegister.getInstance().getProducts().stream().filter(p -> StringUtils.equals((CharSequence)code, (CharSequence)p.getCode())).findFirst().orElse(null);
    }

    public static Set<Class> getServiceProviderClasses(String spiClassName) {
        HashSet classList = Sets.newHashSet();
        try {
            ArrayList classLoaders = Lists.newArrayList((Object[])new ClassLoader[]{Thread.currentThread().getContextClassLoader()});
            for (ClassLoader classLoader : classLoaders) {
                Enumeration<URL> enumeration = classLoader.getResources("META-INF/services/" + spiClassName);
                while (enumeration.hasMoreElements()) {
                    URL url = enumeration.nextElement();
                    List<String> classNames = Lattice.loadSpiFileContent(url);
                    for (String className : classNames) {
                        try {
                            classList.add(Class.forName(className));
                        }
                        catch (Exception e) {
                            log.warn(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        return classList;
    }

    private static List<String> loadSpiFileContent(URL url) {
        ArrayList<String> contentList = new ArrayList<String>();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));){
            String eachLine;
            while (StringUtils.isNotBlank((CharSequence)(eachLine = bufferedReader.readLine()))) {
                eachLine = eachLine.trim();
                contentList.add(eachLine);
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        return contentList;
    }

    private void registerRealizations() {
        Set<Class> classSet = Lattice.getServiceProviderClasses(IBusinessExt.class.getName());
        TemplateRegister.getInstance().registerRealizations(classSet);
    }

    private void registerAbilities() {
        Set<Class> abilityClasses = Lattice.getServiceProviderClasses(IAbility.class.getName());
        this.registeredAbilities.addAll(AbilityRegister.getInstance().register(new AbilityBuildRequest(null, this.mergeAbilityInstancePackage(abilityClasses))));
    }

    private void registerBusinesses() {
        Set<Class> classSet = Lattice.getServiceProviderClasses(IBusiness.class.getName());
        TemplateRegister.getInstance().registerBusinesses(classSet);
    }

    private void registerProducts() {
        Set<Class> classSet = Lattice.getServiceProviderClasses(IProduct.class.getName());
        TemplateRegister.getInstance().registerProducts(classSet);
    }

    private Set<Class> mergeAbilityInstancePackage(Set<Class> abilityClasses) {
        HashSet classesSet = Sets.newHashSet(abilityClasses);
        Set packageSet = abilityClasses.stream().map(p -> p.getPackage().getName()).collect(Collectors.toSet());
        for (String pkg : packageSet) {
            classesSet.addAll(ClassLoaderUtil.scanLatticeClasses(pkg));
        }
        return classesSet;
    }

    public RealizationSpec getRealizationSpecByCode(String code) {
        return TemplateRegister.getInstance().getRealizations().stream().filter(p -> BizCodeUtils.isCodesMatched((String)p.getCode(), (String)code)).findFirst().orElse(null);
    }

    public List<RealizationSpec> getAllRealizations() {
        return TemplateRegister.getInstance().getRealizations();
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isSimpleMode() {
        return this.simpleMode;
    }

    public void setSimpleMode(boolean simpleMode) {
        this.simpleMode = simpleMode;
    }

    public List<BusinessConfig> getBusinessConfigs() {
        return this.businessConfigs;
    }

    public LatticeTemplateManager getTemplateManager() {
        return this.templateManager;
    }

    public List<AbilitySpec> getRegisteredAbilities() {
        return this.registeredAbilities;
    }

    public LatticeRuntimeCache getLatticeRuntimeCache() {
        return this.latticeRuntimeCache;
    }
}

