/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime.ability.delegate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.hifforce.lattice.cache.invoke.InvokeCache;
import org.hifforce.lattice.exception.LatticeRuntimeException;
import org.hifforce.lattice.message.Message;
import org.hifforce.lattice.model.ability.IBusinessExt;
import org.hifforce.lattice.model.business.IBizObject;
import org.hifforce.lattice.model.business.TemplateType;
import org.hifforce.lattice.model.config.BusinessConfig;
import org.hifforce.lattice.model.config.ExtPriority;
import org.hifforce.lattice.model.config.ExtPriorityConfig;
import org.hifforce.lattice.model.context.BizSessionContext;
import org.hifforce.lattice.model.register.BusinessSpec;
import org.hifforce.lattice.model.register.ProductSpec;
import org.hifforce.lattice.model.register.RealizationSpec;
import org.hifforce.lattice.model.register.TemplateSpec;
import org.hifforce.lattice.utils.BizCodeUtils;
import org.hiforce.lattice.runtime.Lattice;
import org.hiforce.lattice.runtime.ability.BaseLatticeAbility;
import org.hiforce.lattice.runtime.ability.execute.RunnerCollection;
import org.hiforce.lattice.runtime.ability.execute.filter.ExtensionFilter;
import org.hiforce.lattice.runtime.ability.execute.filter.ProductFilter;
import org.hiforce.lattice.runtime.ability.execute.runner.ExtensionJavaRunner;
import org.hiforce.lattice.runtime.cache.ExtensionInvokeCache;
import org.hiforce.lattice.runtime.cache.ExtensionRunnerCacheKey;
import org.hiforce.lattice.runtime.cache.LatticeRuntimeCache;
import org.hiforce.lattice.runtime.cache.NotExistedExtensionPointRealization;
import org.hiforce.lattice.runtime.cache.TemplateCache;
import org.hiforce.lattice.runtime.cache.key.ExtensionInvokeCacheKey;
import org.hiforce.lattice.runtime.spi.IRunnerCollectionBuilder;
import org.hiforce.lattice.runtime.spi.LatticeSpiFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseLatticeAbilityDelegate {
    private static final Logger log = LoggerFactory.getLogger(BaseLatticeAbilityDelegate.class);
    public static final Object NULL_OBJECT = new Object();
    private final BaseLatticeAbility ability;

    public BaseLatticeAbilityDelegate(BaseLatticeAbility ability) {
        this.ability = ability;
    }

    public <BusinessExt extends IBusinessExt, R> RunnerCollection<BusinessExt, R> loadExtensionRunners(@Nonnull String extCode, ExtensionFilter filter) {
        String bizCode = this.ability.getContext().getBizCode();
        String scenario = this.ability.getContext().getScenario();
        IBizObject bizObject = this.ability.getContext().getBizObject();
        boolean onlyProduct = !filter.isLoadBusinessExt();
        BusinessConfig businessConfig = Lattice.getInstance().getBusinessConfigByBizCode(bizCode);
        if (null == businessConfig) {
            if (Lattice.getInstance().isSimpleMode()) {
                return this.buildDefaultRunnerCollection(extCode, onlyProduct);
            }
            throw new LatticeRuntimeException("LATTICE-CORE-RT-0012", new Object[]{bizCode});
        }
        List<RunnerCollection.RunnerItemEntry<BusinessExt, R>> cachedRunners = this.getCachedRunners(extCode, businessConfig, filter);
        if (cachedRunners == null) {
            return this.buildDefaultRunnerCollection(extCode, onlyProduct);
        }
        SessionRelatedFilter sessionRelatedFilter = filter == ExtensionFilter.DEFAULT_FILTER ? new NoProductFilterSessionRelatedFilter(filter, bizObject, bizCode) : new SessionRelatedFilter(filter, bizObject, bizCode);
        boolean loadBizExt = filter.isLoadBusinessExt();
        boolean loadDefaultExtension = this.ability.hasDefaultExtension();
        RunnerCollection businessRunnerCollection = RunnerCollection.of(bizObject, this.filterEffectiveRunners(cachedRunners), sessionRelatedFilter, this.getDefaultRunnerProducer(bizCode, extCode, scenario), loadBizExt, loadDefaultExtension);
        return RunnerCollection.combine(this.buildCustomRunnerCollection(extCode, bizObject), businessRunnerCollection);
    }

    private <BusinessExt extends IBusinessExt, R> List<RunnerCollection.RunnerItemEntry<BusinessExt, R>> filterEffectiveRunners(List<RunnerCollection.RunnerItemEntry<BusinessExt, R>> runners) {
        ArrayList output = Lists.newArrayList();
        for (RunnerCollection.RunnerItemEntry runner : runners) {
            if (TemplateType.PRODUCT != runner.getTemplate().getType()) {
                output.add(runner);
                continue;
            }
            BizSessionContext bizSessionContext = (BizSessionContext)InvokeCache.instance().get(BizSessionContext.class, BizSessionContext.class);
            List effective = (List)bizSessionContext.getEffectiveProducts().get(this.ability.getContext().getBizCode());
            if (effective.stream().noneMatch(p -> StringUtils.equals((CharSequence)p.getCode(), (CharSequence)runner.getTemplate().getCode()))) continue;
            output.add(runner);
        }
        return runners;
    }

    private <BusinessExt extends IBusinessExt, R> RunnerCollection<BusinessExt, R> buildCustomRunnerCollection(String extensionCode, IBizObject bizInstance) {
        IRunnerCollectionBuilder runnerCollectionBuilder = LatticeSpiFactory.getInstance().getRunnerCollectionBuilder();
        if (!runnerCollectionBuilder.isSupport(this.ability, extensionCode)) {
            return RunnerCollection.of(bizInstance, Lists.newArrayList(), RunnerCollection.ACCEPT_ALL);
        }
        return runnerCollectionBuilder.buildCustomRunnerCollection(this.ability, extensionCode);
    }

    private static boolean isTemplateEffected(String bizCode, TemplateSpec template) {
        if (template.getType() == TemplateType.BUSINESS) {
            return BizCodeUtils.isCodesMatched((String)bizCode, (String)template.getCode());
        }
        BizSessionContext bizSessionContext = (BizSessionContext)InvokeCache.instance().get(BizSessionContext.class, BizSessionContext.class);
        if (null == bizSessionContext) {
            return false;
        }
        List effective = (List)bizSessionContext.getEffectiveProducts().get(bizCode);
        return !effective.stream().noneMatch(p -> StringUtils.equals((CharSequence)p.getCode(), (CharSequence)template.getCode()));
    }

    private <ExtensionPoints extends IBusinessExt, R> List<RunnerCollection.RunnerItemEntry<ExtensionPoints, R>> getCachedRunners(String extensionCode, BusinessConfig businessConfig, ExtensionFilter filter) {
        ExtensionRunnerCacheKey key;
        String scenario = this.ability.getContext().getScenario();
        String bizCode = this.ability.getContext().getBizCode();
        boolean supportCustomization = this.ability.supportCustomization();
        boolean isOnlyProduct = !filter.isLoadBusinessExt();
        LatticeRuntimeCache runtimeCache = Lattice.getInstance().getLatticeRuntimeCache();
        Object result = runtimeCache.getCachedExtensionRunner(this.ability, key = new ExtensionRunnerCacheKey(extensionCode, bizCode, scenario, supportCustomization, isOnlyProduct));
        if (result != null) {
            if (result == NULL_OBJECT) {
                return null;
            }
            return (List)result;
        }
        ExtPriorityConfig priorityConfig = businessConfig.getExtensions().stream().filter(p -> StringUtils.equals((CharSequence)p.getExtCode(), (CharSequence)extensionCode)).findFirst().orElse(null);
        if (null == priorityConfig) {
            runtimeCache.doCacheExtensionRunner(this.ability, key, NULL_OBJECT);
            return null;
        }
        ArrayList<RunnerCollection.RunnerItemEntry<ExtensionPoints, R>> extensionRunners = new ArrayList<RunnerCollection.RunnerItemEntry<ExtensionPoints, R>>();
        for (ExtPriority config : businessConfig.getExtPriorityByCode(extensionCode, isOnlyProduct)) {
            RunnerCollection.RunnerItemEntry<ExtensionPoints, R> runnerItemEntry;
            BizSessionContext bizSessionContext;
            if (null == config || null == (bizSessionContext = (BizSessionContext)InvokeCache.instance().get(BizSessionContext.class, BizSessionContext.class)) || config.getType() == TemplateType.PRODUCT && !businessConfig.productInstalled(config.getCode()) || null == (runnerItemEntry = this.buildExtensionJavaRunnerItemEntry(extensionCode, config, bizCode, scenario))) continue;
            extensionRunners.add(runnerItemEntry);
        }
        runtimeCache.doCacheExtensionRunner(this.ability, key, extensionRunners);
        return extensionRunners;
    }

    private <ExtensionPoints extends IBusinessExt, R> RunnerCollection.RunnerItemEntry<ExtensionPoints, R> buildExtensionJavaRunnerItemEntry(String extensionCode, ExtPriority config, String bizCode, String scenario) {
        BusinessSpec template;
        boolean supportCustomization = this.ability.supportCustomization();
        ExtensionJavaRunner extensionJavaRunner = null;
        if (null == config) {
            if (log.isInfoEnabled()) {
                log.info(Message.code((String)"LATTICE-CORE-RT-0013", (Object[])new Object[]{extensionCode, bizCode}).getText());
            }
            return null;
        }
        Object object = template = config.getType() == TemplateType.BUSINESS ? this.getBusinessSpec(config.getCode()) : this.getProductSpec(config.getCode());
        if (supportCustomization) {
            IBusinessExt extImpl = this.loadExtensionRealization(bizCode, scenario, (TemplateSpec)template, extensionCode);
            if (null == extImpl) {
                if (log.isInfoEnabled()) {
                    log.info("[Lattice]The ExtensionFacade or ExtensionImplement is null. bizCode: [{}], extCode: [{}]", (Object)bizCode, (Object)extensionCode);
                }
                extensionJavaRunner = null;
            } else {
                extensionJavaRunner = new ExtensionJavaRunner(extensionCode, extImpl);
            }
        } else {
            extensionJavaRunner = new ExtensionJavaRunner(extensionCode, this.ability.getDefaultRealization());
        }
        if (extensionJavaRunner != null) {
            return new RunnerCollection.RunnerItemEntry((TemplateSpec)template, extensionJavaRunner, this.ability);
        }
        return null;
    }

    public <BusinessExt extends IBusinessExt, R> RunnerCollection<BusinessExt, R> buildDefaultRunnerCollection(String extCode, boolean onlyProduct) {
        String bizCode = this.ability.getContext().getBizObject().getBizCode();
        String scenario = this.ability.getContext().getScenario();
        boolean loadBizExt = !onlyProduct;
        boolean loadDefaultExt = this.ability.hasDefaultExtension();
        RunnerCollection runnerCollection = LatticeSpiFactory.getInstance().getRunnerCollectionBuilder().buildCustomRunnerCollection(this.ability, extCode);
        if (loadBizExt) {
            RunnerCollection.Producer producer = this.getDefaultRunnerProducer(bizCode, extCode, scenario);
            return RunnerCollection.combine(runnerCollection, producer, loadBizExt, loadDefaultExt);
        }
        return runnerCollection;
    }

    private <ExtensionPoints extends IBusinessExt, R> RunnerCollection.Producer<ExtensionPoints, R> getDefaultRunnerProducer(String bizCode, String extensionCode, String scenario) {
        return () -> {
            ExtensionJavaRunner javaRunner = null;
            BusinessSpec template = this.getBusinessSpec(bizCode);
            if (this.ability.supportCustomization()) {
                IBusinessExt extImpl = this.loadExtensionRealization(bizCode, scenario, (TemplateSpec)template, extensionCode);
                javaRunner = null == extImpl ? null : new ExtensionJavaRunner(extensionCode, extImpl);
            } else if (this.ability.hasDefaultExtension()) {
                javaRunner = new ExtensionJavaRunner(extensionCode, this.ability.getDefaultRealization());
            }
            if (null == javaRunner) {
                return null;
            }
            return new RunnerCollection.RunnerItemEntry((TemplateSpec)template, javaRunner, this.ability);
        };
    }

    private BusinessSpec getBusinessSpec(String bizCode) {
        return Lattice.getInstance().getAllRegisteredBusinesses().stream().filter(p -> StringUtils.equals((CharSequence)bizCode, (CharSequence)p.getCode())).findFirst().orElse(null);
    }

    private ProductSpec getProductSpec(String code) {
        return Lattice.getInstance().getAllRegisteredProducts().stream().filter(p -> StringUtils.equals((CharSequence)code, (CharSequence)p.getCode())).findFirst().orElse(null);
    }

    private IBusinessExt loadExtensionRealization(String bizCode, String scenario, TemplateSpec template, String extPointCode) {
        ExtensionInvokeCacheKey cacheKey = null == template ? null : new ExtensionInvokeCacheKey(scenario, template, extPointCode);
        return this.internalLoadExtensionRealization(cacheKey, bizCode, scenario, template, extPointCode);
    }

    private IBusinessExt internalLoadExtensionRealization(ExtensionInvokeCacheKey cacheKey, String bizCode, String scenario, TemplateSpec template, String extPointCode) {
        IBusinessExt extImpl = ExtensionInvokeCache.getInstance().getCachedExtensionRealization(cacheKey);
        if (extImpl instanceof NotExistedExtensionPointRealization) {
            return null;
        }
        if (extImpl != null) {
            return extImpl;
        }
        if (null == template) {
            if (this.ability.hasDefaultExtension()) {
                return this.ability.getDefaultRealization();
            }
            return null;
        }
        IBusinessExt extFacade = null;
        extFacade = this.findIExtensionPointsFacadeViaScenario(scenario, template, extPointCode);
        if (extFacade != null) {
            extImpl = extFacade.getBusinessExtByCode(extPointCode, scenario);
        } else if (this.ability.hasDefaultExtension()) {
            extImpl = this.ability.getDefaultRealization();
        }
        if (null == extImpl) {
            ExtensionInvokeCache.getInstance().doCacheExtensionRealization(cacheKey, new NotExistedExtensionPointRealization());
            return null;
        }
        return ExtensionInvokeCache.getInstance().doCacheExtensionRealization(cacheKey, extImpl);
    }

    public IBusinessExt findIExtensionPointsFacadeViaScenario(String scenario, TemplateSpec template, String extPointCode) {
        IBusinessExt extFacade;
        block3: {
            IBusinessExt facade;
            List<RealizationSpec> realizationSpecs;
            TemplateCache templateCache;
            block4: {
                extFacade = null;
                templateCache = Lattice.getInstance().getLatticeRuntimeCache().getTemplateCache();
                realizationSpecs = Lattice.getInstance().getAllRegisteredRealizations();
                if (!StringUtils.isEmpty((CharSequence)scenario)) break block4;
                for (RealizationSpec realization : realizationSpecs) {
                    IBusinessExt facade2;
                    if (StringUtils.isNotEmpty((CharSequence)realization.getScenario()) || (facade2 = realization.getBusinessExt()) == null || !templateCache.templateCodeMatched(realization.getCode(), template.getCode()) || null == facade2.getBusinessExtByCode(extPointCode, scenario)) continue;
                    extFacade = facade2;
                    break block3;
                }
                break block3;
            }
            for (RealizationSpec realization : realizationSpecs) {
                if (!StringUtils.equals((CharSequence)scenario, (CharSequence)realization.getScenario()) || (facade = realization.getBusinessExt()) == null || !templateCache.templateCodeMatched(realization.getCode(), template.getCode()) || null == facade.getBusinessExtByCode(extPointCode, scenario)) continue;
                extFacade = facade;
                break;
            }
            if (null != extFacade) break block3;
            for (RealizationSpec realization : realizationSpecs) {
                if (StringUtils.isNotEmpty((CharSequence)realization.getScenario()) || (facade = realization.getBusinessExt()) == null || !templateCache.templateCodeMatched(realization.getCode(), template.getCode()) || null == facade.getBusinessExtByCode(extPointCode, scenario)) continue;
                extFacade = facade;
                break;
            }
        }
        return extFacade;
    }

    private static class NoProductFilterSessionRelatedFilter<ExtensionPoints, R>
    extends SessionRelatedFilter<ExtensionPoints, R> {
        public NoProductFilterSessionRelatedFilter(ExtensionFilter extensionRunnerFilter, IBizObject bizInstance, String bizCode) {
            super(extensionRunnerFilter, bizInstance, bizCode);
        }

        @Override
        public boolean test(RunnerCollection.RunnerItemEntry<ExtensionPoints, R> entry) {
            return BaseLatticeAbilityDelegate.isTemplateEffected(this.bizObject.getBizCode(), entry.getTemplate());
        }
    }

    private static class SessionRelatedFilter<ExtensionPoints, R>
    implements Predicate<RunnerCollection.RunnerItemEntry<ExtensionPoints, R>> {
        private ProductFilter productFilter;
        private ExtensionFilter extensionFilter;
        protected IBizObject bizObject;
        protected String bizCode;

        public SessionRelatedFilter(ExtensionFilter extensionFilter, IBizObject bizObject, String bizCode) {
            this.productFilter = extensionFilter.getProductFilter();
            this.extensionFilter = extensionFilter;
            this.bizObject = bizObject;
            this.bizCode = bizCode;
        }

        @Override
        public boolean test(RunnerCollection.RunnerItemEntry<ExtensionPoints, R> entry) {
            String templateCode = entry.getTemplate().getCode();
            if (null != this.productFilter && !this.productFilter.getAllowedProductCodes().contains(templateCode)) {
                return false;
            }
            IBizObject bizInstance = this.bizObject;
            return BaseLatticeAbilityDelegate.isTemplateEffected(bizInstance.getBizCode(), entry.getTemplate());
        }
    }
}

