/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime.ability.reduce;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.CollectionUtils;
import org.hifforce.lattice.annotation.model.ReduceType;
import org.hifforce.lattice.model.ability.execute.Reducer;

public class FlatList<T>
extends Reducer<List<T>, List<T>> {
    private final Predicate<List<T>> predicate;

    public FlatList(@Nonnull Predicate<List<T>> predicate) {
        Objects.requireNonNull(predicate);
        this.predicate = predicate;
    }

    public boolean willBreak(Collection<List<T>> elements) {
        return false;
    }

    public ReduceType reducerType() {
        return ReduceType.ALL;
    }

    public List<T> reduce(Collection<List<T>> elements) {
        if (CollectionUtils.isEmpty(elements)) {
            return Lists.newArrayList();
        }
        ArrayList results = Lists.newArrayList();
        for (List<T> element : elements) {
            if (!this.predicate.test(element) || !CollectionUtils.isNotEmpty(element)) continue;
            results.addAll(element);
        }
        return results;
    }

    public Predicate<List<T>> getPredicate() {
        return this.predicate;
    }
}

