/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime.cache;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hifforce.lattice.cache.IMultiKeyCache;

public abstract class MultiKeyCache<K1, K2, V>
implements IMultiKeyCache<K1, K2, V> {
    protected Map<K1, V> firstKeyCacheMap;
    protected Map<K2, V> secondKeyCacheMap;
    protected Map<K1, K2> firstKey2SecondKeyMap;

    public int size() {
        if (null == this.firstKeyCacheMap) {
            return 0;
        }
        return this.firstKeyCacheMap.size();
    }

    public void clear() {
        this.firstKeyCacheMap.clear();
        this.secondKeyCacheMap.clear();
        this.firstKey2SecondKeyMap.clear();
    }

    public void remove(K1 key1) {
        K2 key2;
        V v = this.firstKeyCacheMap.remove(key1);
        if (null != v && null != (key2 = this.firstKey2SecondKeyMap.remove(key1))) {
            this.secondKeyCacheMap.remove(key2);
        }
    }

    public MultiKeyCache() {
        this.firstKeyCacheMap = new ConcurrentHashMap<K1, V>(120);
        this.secondKeyCacheMap = new ConcurrentHashMap<K2, V>(120);
        this.firstKey2SecondKeyMap = new ConcurrentHashMap<K1, K2>(120);
    }

    public MultiKeyCache(int initialCapacity) {
        this.firstKeyCacheMap = new ConcurrentHashMap<K1, V>(initialCapacity);
        this.secondKeyCacheMap = new ConcurrentHashMap<K2, V>(initialCapacity);
        this.firstKey2SecondKeyMap = new ConcurrentHashMap<K1, K2>(initialCapacity);
    }

    public K2 getSecondKeyViaFirstKey(K1 key1) {
        return this.firstKey2SecondKeyMap.get(key1);
    }

    public Collection<V> values() {
        return this.firstKeyCacheMap.values();
    }

    public V put(K1 firstKey, K2 secondKey, V cacheValue) {
        if (null == cacheValue) {
            return null;
        }
        if (null != firstKey) {
            this.firstKeyCacheMap.put(firstKey, cacheValue);
        }
        if (null != secondKey) {
            this.secondKeyCacheMap.put(secondKey, cacheValue);
        }
        if (null != firstKey && null != secondKey) {
            this.firstKey2SecondKeyMap.put(firstKey, secondKey);
        }
        return cacheValue;
    }

    public V getFirstKeyFirst(K1 firstKey, K2 secondKey) {
        V v;
        if (null != firstKey && null != (v = this.firstKeyCacheMap.get(firstKey))) {
            return v;
        }
        if (null != secondKey && null != (v = this.secondKeyCacheMap.get(secondKey))) {
            return v;
        }
        return null;
    }

    public V getSecondKeyFirst(K1 firstKey, K2 secondKey) {
        V v;
        if (null != secondKey && null != (v = this.secondKeyCacheMap.get(secondKey))) {
            return v;
        }
        if (null != firstKey && null != (v = this.firstKeyCacheMap.get(firstKey))) {
            return v;
        }
        return null;
    }

    public V getKey1Only(K1 firstKey) {
        if (null != firstKey) {
            return this.firstKeyCacheMap.get(firstKey);
        }
        return null;
    }

    public V getKey2Only(K2 secondKey) {
        if (null != secondKey) {
            return this.secondKeyCacheMap.get(secondKey);
        }
        return null;
    }
}

