/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime.spi;

import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.collections4.CollectionUtils;
import org.hifforce.lattice.model.ability.IAbility;
import org.hifforce.lattice.model.ability.provider.IAbilityProviderCreator;
import org.hifforce.lattice.spi.annotation.AbilityAnnotationParser;
import org.hifforce.lattice.spi.annotation.BusinessAnnotationParser;
import org.hifforce.lattice.spi.annotation.ExtensionAnnotationParser;
import org.hifforce.lattice.spi.annotation.ProductAnnotationParser;
import org.hifforce.lattice.spi.annotation.RealizationAnnotationParser;
import org.hifforce.lattice.spi.annotation.ScanSkipAnnotationParser;
import org.hifforce.lattice.spi.config.BusinessConfigLoadSpi;
import org.hiforce.lattice.runtime.ability.execute.RunnerCollection;
import org.hiforce.lattice.runtime.ability.provider.DefaultAbilityProviderCreator;
import org.hiforce.lattice.runtime.spi.IRunnerCollectionBuilder;

public class LatticeSpiFactory {
    private static volatile LatticeSpiFactory instance;
    private static ClassLoader classLoader;
    private List<AbilityAnnotationParser> abilityAnnotationParsers;
    private List<ExtensionAnnotationParser> extensionAnnotationParsers;
    private List<ScanSkipAnnotationParser> scanSkipAnnotationParsers;
    private List<RealizationAnnotationParser> realizationAnnotationParsers;
    private List<ProductAnnotationParser> productAnnotationParsers;
    private List<BusinessAnnotationParser> businessAnnotationParsers;
    private IAbilityProviderCreator abilityProviderCreator;
    private IRunnerCollectionBuilder runnerCollectionBuilder;
    private List<BusinessConfigLoadSpi> businessConfigLoads;

    private LatticeSpiFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LatticeSpiFactory getInstance() {
        if (null != instance) return instance;
        Class<LatticeSpiFactory> clazz = LatticeSpiFactory.class;
        synchronized (LatticeSpiFactory.class) {
            if (null != instance) return instance;
            instance = new LatticeSpiFactory();
            classLoader = LatticeSpiFactory.class.getClassLoader();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public List<BusinessConfigLoadSpi> getBusinessConfigLoads() {
        if (null == this.businessConfigLoads) {
            this.businessConfigLoads = this.getCustomServiceProviders(BusinessConfigLoadSpi.class);
        }
        if (CollectionUtils.isNotEmpty(this.businessConfigLoads)) {
            this.businessConfigLoads.forEach(p -> p.setClassLoader(this.getClassLoader()));
            this.businessConfigLoads.sort(Comparator.comparingInt(BusinessConfigLoadSpi::getPriority));
        }
        return this.businessConfigLoads;
    }

    public List<AbilityAnnotationParser> getAbilityAnnotationParsers() {
        if (null == this.abilityAnnotationParsers) {
            this.abilityAnnotationParsers = this.getCustomServiceProviders(AbilityAnnotationParser.class);
        }
        return this.abilityAnnotationParsers;
    }

    public List<ProductAnnotationParser> getProductAnnotationParsers() {
        if (null == this.productAnnotationParsers) {
            this.productAnnotationParsers = this.getCustomServiceProviders(ProductAnnotationParser.class);
        }
        return this.productAnnotationParsers;
    }

    public List<BusinessAnnotationParser> getBusinessAnnotationParsers() {
        if (null == this.businessAnnotationParsers) {
            this.businessAnnotationParsers = this.getCustomServiceProviders(BusinessAnnotationParser.class);
        }
        return this.businessAnnotationParsers;
    }

    public List<ExtensionAnnotationParser> getExtensionAnnotationParsers() {
        if (null == this.extensionAnnotationParsers) {
            this.extensionAnnotationParsers = this.getCustomServiceProviders(ExtensionAnnotationParser.class);
        }
        return this.extensionAnnotationParsers;
    }

    public List<RealizationAnnotationParser> getRealizationAnnotationParsers() {
        if (null == this.realizationAnnotationParsers) {
            this.realizationAnnotationParsers = this.getCustomServiceProviders(RealizationAnnotationParser.class);
        }
        return this.realizationAnnotationParsers;
    }

    public List<ScanSkipAnnotationParser> getScanSkipAnnotationParsers() {
        if (null == this.scanSkipAnnotationParsers) {
            this.scanSkipAnnotationParsers = this.getCustomServiceProviders(ScanSkipAnnotationParser.class);
        }
        return this.scanSkipAnnotationParsers;
    }

    public <T> List<T> getCustomServiceProviders(Class<T> spiClass) {
        ServiceLoader<T> serializers = ServiceLoader.load(spiClass, classLoader);
        return StreamSupport.stream(serializers.spliterator(), false).distinct().collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAbilityProviderCreator getAbilityProviderCreator() {
        if (null != this.abilityProviderCreator) {
            return this.abilityProviderCreator;
        }
        Class<LatticeSpiFactory> clazz = LatticeSpiFactory.class;
        synchronized (LatticeSpiFactory.class) {
            if (null == this.abilityProviderCreator) {
                ServiceLoader<IAbilityProviderCreator> serializers = ServiceLoader.load(IAbilityProviderCreator.class, classLoader);
                Optional<DefaultAbilityProviderCreator> serializer = StreamSupport.stream(serializers.spliterator(), false).findFirst();
                this.abilityProviderCreator = serializer.orElse(new DefaultAbilityProviderCreator());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.abilityProviderCreator;
        }
    }

    private ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRunnerCollectionBuilder getRunnerCollectionBuilder() {
        if (null != this.runnerCollectionBuilder) {
            return this.runnerCollectionBuilder;
        }
        Class<LatticeSpiFactory> clazz = LatticeSpiFactory.class;
        synchronized (LatticeSpiFactory.class) {
            if (null == this.runnerCollectionBuilder) {
                ServiceLoader<IRunnerCollectionBuilder> serializers = ServiceLoader.load(IRunnerCollectionBuilder.class, classLoader);
                Optional<1> serializer = StreamSupport.stream(serializers.spliterator(), false).findFirst();
                this.runnerCollectionBuilder = serializer.orElse(new IRunnerCollectionBuilder(){

                    @Override
                    public boolean isSupport(IAbility ability, String extensionCode) {
                        return false;
                    }

                    public RunnerCollection buildCustomRunnerCollection(IAbility ability, String extensionCode) {
                        return RunnerCollection.of(ability.getContext().getBizObject(), Lists.newArrayList(), RunnerCollection.ACCEPT_ALL);
                    }
                });
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.runnerCollectionBuilder;
        }
    }
}

