/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime.utils;

import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.hifforce.lattice.annotation.model.AbilityAnnotation;
import org.hifforce.lattice.annotation.model.ScanSkipAnnotation;
import org.hifforce.lattice.spi.annotation.AbilityAnnotationParser;
import org.hifforce.lattice.spi.annotation.ScanSkipAnnotationParser;
import org.hiforce.lattice.runtime.spi.LatticeSpiFactory;
import org.hiforce.lattice.runtime.utils.LatticeClassUtils;
import org.springframework.core.annotation.AnnotationUtils;

public class LatticeAnnotationUtils
extends AnnotationUtils {
    private static final Map<Class<?>, Boolean> annotatedInterfaceCache = new WeakHashMap();

    public static AbilityAnnotation getAbilityAnnotation(Class<?> abilityClass) {
        for (AbilityAnnotationParser parser : LatticeSpiFactory.getInstance().getAbilityAnnotationParsers()) {
            Annotation annotation = AnnotationUtils.findAnnotation(abilityClass, (Class)parser.getAnnotationClass());
            if (null == annotation) continue;
            return parser.buildAnnotationInfo(annotation, abilityClass);
        }
        return null;
    }

    public static ScanSkipAnnotation getScanSkipAnnotation(Method method) {
        for (ScanSkipAnnotationParser parser : LatticeSpiFactory.getInstance().getScanSkipAnnotationParsers()) {
            Annotation annotation = AnnotationUtils.findAnnotation((Method)method, (Class)parser.getAnnotationClass());
            if (null == annotation) continue;
            return parser.buildAnnotationInfo(annotation);
        }
        return null;
    }

    public static ScanSkipAnnotation getScanSkipAnnotation(Class<?> targetClass) {
        for (ScanSkipAnnotationParser parser : LatticeSpiFactory.getInstance().getScanSkipAnnotationParsers()) {
            Annotation annotation = AnnotationUtils.getAnnotation(targetClass, (Class)parser.getAnnotationClass());
            if (null == annotation) continue;
            return parser.buildAnnotationInfo(annotation);
        }
        return null;
    }

    public static <A extends Annotation> A findAnnotation(Method method, Class<A> annotationType) {
        Object annotation = method.getAnnotation(annotationType);
        if (null != annotation) {
            return annotation;
        }
        annotation = AnnotationUtils.findAnnotation((Method)method, annotationType);
        if (null != annotation) {
            return annotation;
        }
        Class<?> clazz = method.getDeclaringClass();
        annotation = LatticeAnnotationUtils.searchOnInterfaces(method, annotationType, clazz.getInterfaces());
        while (annotation == null && (clazz = clazz.getSuperclass()) != null && !clazz.equals(Object.class)) {
            try {
                Method equivalentMethod = clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
                annotation = LatticeAnnotationUtils.getAnnotation((Method)equivalentMethod, annotationType);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (annotation != null) continue;
            annotation = LatticeAnnotationUtils.searchOnInterfaces(method, annotationType, clazz.getInterfaces());
        }
        return annotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isInterfaceWithAnnotatedMethods(Class<?> iface) {
        Map<Class<?>, Boolean> map = annotatedInterfaceCache;
        synchronized (map) {
            Boolean flag = annotatedInterfaceCache.get(iface);
            if (flag != null) {
                return flag;
            }
            boolean found = false;
            for (Method ifcMethod : iface.getMethods()) {
                if (ifcMethod.getAnnotations().length <= 0) continue;
                found = true;
                break;
            }
            annotatedInterfaceCache.put(iface, found);
            return found;
        }
    }

    private static boolean isParameterIsEqual(Class<?>[] targetParams, Class<?>[] methodParams) {
        if (null == targetParams && null == methodParams) {
            return true;
        }
        if (null == targetParams || methodParams == null) {
            return false;
        }
        if (targetParams.length != methodParams.length) {
            return false;
        }
        for (int i = 0; i < targetParams.length; ++i) {
            if (LatticeClassUtils.isSubClassOf(targetParams[0], methodParams[0])) continue;
            return false;
        }
        return true;
    }

    private static List<Method> findSameNameMethodWithSameParamNum(Method targetMethod, Method[] methods) {
        ArrayList output = Lists.newArrayList();
        for (Method method : methods) {
            if (!StringUtils.equals((CharSequence)targetMethod.getName(), (CharSequence)method.getName()) || targetMethod.getParameterTypes().length != method.getParameterTypes().length || !LatticeAnnotationUtils.isParameterIsEqual(targetMethod.getParameterTypes(), method.getParameterTypes())) continue;
            output.add(method);
        }
        return output;
    }

    private static <A extends Annotation> A lowLevelSearchAnnotation(Method method, Class<A> annotationType, Class<?> iface) {
        Annotation annotation = null;
        try {
            Method equivalentMethod = iface.getMethod(method.getName(), method.getParameterTypes());
            annotation = LatticeAnnotationUtils.getAnnotation((Method)equivalentMethod, annotationType);
        }
        catch (NoSuchMethodException ex) {
            Method oneMethod;
            Method[] methods;
            Method[] methodArray = methods = iface.getMethods();
            int n = methodArray.length;
            for (int i = 0; !(i >= n || (oneMethod = methodArray[i]).getName().equals(method.getName()) && (annotation = LatticeAnnotationUtils.getAnnotation((Method)oneMethod, annotationType)) != null); ++i) {
            }
        }
        return (A)annotation;
    }

    private static <A extends Annotation> A searchOnInterfaces(Method method, Class<A> annotationType, Class<?>[] classes) {
        Annotation annotation = null;
        for (Class<?> clz : classes) {
            if (!LatticeAnnotationUtils.isInterfaceWithAnnotatedMethods(clz)) continue;
            List<Method> maybeMethods = LatticeAnnotationUtils.findSameNameMethodWithSameParamNum(method, clz.getMethods());
            if (CollectionUtils.isNotEmpty(maybeMethods)) {
                annotation = maybeMethods.size() == 1 ? LatticeAnnotationUtils.getAnnotation((Method)maybeMethods.get(0), annotationType) : (Annotation)LatticeAnnotationUtils.lowLevelSearchAnnotation(method, annotationType, clz);
            }
            if (annotation != null) break;
            Class<?>[] superIfcs = clz.getInterfaces();
            annotation = (Annotation)LatticeAnnotationUtils.searchOnInterfaces(method, annotationType, superIfcs);
        }
        return (A)annotation;
    }
}

