/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime.session;

import org.hifforce.lattice.exception.LatticeRuntimeException;

public abstract class Scope<Resp> {
    protected static Entrance newEntrance() {
        return new EntranceImpl();
    }

    protected abstract Entrance getEntrance();

    protected abstract Resp execute() throws LatticeRuntimeException;

    protected abstract void entrance();

    protected abstract void exit();

    public Resp invoke() throws LatticeRuntimeException {
        Entrance entrance = this.getEntrance();
        try {
            entrance.get().increaseCount();
            if (entrance.get().getCount() == 1) {
                this.entrance();
            }
            Resp Resp = this.execute();
            return Resp;
        }
        finally {
            entrance.get().decreaseCount();
            if (entrance.get().getCount() == 0) {
                entrance.clearCount();
                this.exit();
            }
        }
    }

    private static class EntranceImpl
    extends ThreadLocal<EntranceImpl>
    implements Entrance {
        private int count = 0;

        private EntranceImpl() {
        }

        @Override
        protected EntranceImpl initialValue() {
            return new EntranceImpl();
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        public void increaseCount() {
            ++this.count;
        }

        @Override
        public void clearCount() {
            this.remove();
        }

        @Override
        public void decreaseCount() {
            --this.count;
        }
    }

    protected static interface Entrance {
        public int getCount();

        public void increaseCount();

        public void decreaseCount();

        public void clearCount();

        public Entrance get();
    }
}

