/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime.ability;

import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.hifforce.lattice.annotation.model.AbilityAnnotation;
import org.hifforce.lattice.exception.LatticeRuntimeException;
import org.hifforce.lattice.message.Message;
import org.hifforce.lattice.model.ability.IAbility;
import org.hifforce.lattice.model.ability.IBusinessExt;
import org.hifforce.lattice.model.ability.execute.ExtensionCallback;
import org.hifforce.lattice.model.ability.execute.Reducer;
import org.hifforce.lattice.model.business.IBizObject;
import org.hifforce.lattice.model.context.AbilityContext;
import org.hifforce.lattice.model.register.ExtensionPointSpec;
import org.hifforce.lattice.utils.LatticeAnnotationUtils;
import org.hiforce.lattice.runtime.Lattice;
import org.hiforce.lattice.runtime.ability.delegate.BaseLatticeAbilityDelegate;
import org.hiforce.lattice.runtime.ability.execute.ExecuteResult;
import org.hiforce.lattice.runtime.ability.execute.RunnerCollection;
import org.hiforce.lattice.runtime.ability.execute.filter.ExtensionFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseLatticeAbility<BusinessExt extends IBusinessExt>
implements IAbility<BusinessExt> {
    private static final Logger log = LoggerFactory.getLogger(BaseLatticeAbility.class);
    private final IBizObject bizObject;
    private final String instanceCode;
    private final BaseLatticeAbilityDelegate delegate;

    public BaseLatticeAbility(IBizObject bizObject) {
        this.bizObject = bizObject;
        this.instanceCode = this.getClass().getName();
        this.delegate = new BaseLatticeAbilityDelegate(this);
    }

    public AbilityContext getContext() {
        return new AbilityContext(this.bizObject);
    }

    public String getCode() {
        AbilityAnnotation annotation = LatticeAnnotationUtils.getAbilityAnnotation(this.getClass());
        if (null == annotation) {
            return null;
        }
        return annotation.getCode();
    }

    public <R> void handleReduceExecuteFailed(ExecuteResult<R> result) {
        log.error(result.getErrLogText());
    }

    public boolean supportChecking() {
        return true;
    }

    public boolean supportCustomization() {
        return true;
    }

    public boolean hasDefaultExtension() {
        return true;
    }

    public final <T, R> R reduceExecute(String extensionCode, ExtensionCallback<BusinessExt, T> callback, @Nonnull Reducer<T, R> reducer) {
        return this.reduceExecute(extensionCode, callback, reducer, ExtensionFilter.DEFAULT_FILTER);
    }

    public final <T, R> R reduceExecute(String extensionCode, ExtensionCallback<BusinessExt, T> callback, @Nonnull Reducer<T, R> reducer, ExtensionFilter filter) {
        ExecuteResult<R> result = this.reduceExecuteWithDetailResult(extensionCode, callback, reducer, filter);
        if (null == result || null == result.getResult()) {
            return null;
        }
        if (!result.isSuccess()) {
            this.handleReduceExecuteFailed(result);
            return null;
        }
        return result.getResult();
    }

    public final <T, R> ExecuteResult<R> reduceExecuteWithDetailResult(String extCode, ExtensionCallback<BusinessExt, T> callback, @Nonnull Reducer<T, R> reducer, ExtensionFilter filter) {
        String bizCode;
        if (StringUtils.isEmpty((CharSequence)extCode)) {
            throw new LatticeRuntimeException("LATTICE-CORE-RT-0007", new Object[0]);
        }
        if (null == this.getContext().getBizObject()) {
            return ExecuteResult.failed(extCode, Message.code((String)"LATTICE-CORE-RT-0018", (Object[])new Object[0]));
        }
        if (this.getContext().getBizObject().getBizContext().getBizId() == null) {
            return ExecuteResult.failed(extCode, Message.code((String)"LATTICE-CORE-RT-0019", (Object[])new Object[0]));
        }
        if (!this.supportChecking()) {
            return ExecuteResult.success(extCode, reducer.reduceName(), Message.code((String)"LATTICE-CORE-RT-0020", (Object[])new Object[]{this.getClass().getName(), Optional.ofNullable(this.getContext().getBizObject()).map(p -> p.getBizContext()).map(p -> p.getBizInfo()).orElse(this.getContext().getBizObject().getBizId().toString()), extCode}));
        }
        ExtensionPointSpec extensionPointSpec = Lattice.getInstance().getLatticeRuntimeCache().getExtensionPointSpecByCode(extCode);
        if (null == extensionPointSpec && !Lattice.getInstance().isSimpleMode()) {
            throw new LatticeRuntimeException("LATTICE-CORE-RT-0016", new Object[]{extCode});
        }
        if (null != extensionPointSpec && !reducer.reducerType().equals((Object)extensionPointSpec.getReduceType())) {
            log.warn(Message.code((String)"LATTICE-CORE-RT-0017", (Object[])new Object[]{extCode, reducer.reducerType(), extensionPointSpec.getReduceType()}).getText());
        }
        if (StringUtils.isEmpty((CharSequence)(bizCode = this.getContext().getBizObject().getBizCode()))) {
            throw new LatticeRuntimeException("LATTICE-CORE-RT-0008", new Object[0]);
        }
        ArrayList results = new ArrayList(16);
        RunnerCollection runnerCollection = this.delegate.loadExtensionRunners(extCode, filter);
        return runnerCollection.distinct().reduceExecute(extCode, reducer, callback, results);
    }

    public String getInstanceCode() {
        return this.instanceCode;
    }
}

