/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime.ability.reduce;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.CollectionUtils;
import org.hifforce.lattice.annotation.model.ReduceType;
import org.hifforce.lattice.model.ability.execute.Reducer;

public class AllMatch<T>
extends Reducer<T, Boolean> {
    private final Predicate<T> predicate;

    public AllMatch(@Nonnull Predicate<T> predicate) {
        Objects.requireNonNull(predicate);
        this.predicate = predicate;
        this.setResult(true);
    }

    public boolean willBreak(Collection<T> elements) {
        if (CollectionUtils.isEmpty(elements)) {
            return false;
        }
        for (T element : elements) {
            if (this.predicate.test(element)) continue;
            this.setBreak();
            this.setResult(false);
            return true;
        }
        return false;
    }

    public ReduceType reducerType() {
        return ReduceType.ALL;
    }

    public Boolean reduce(Collection<T> elements) {
        if (this.isHasBreak()) {
            return (Boolean)this.getResult();
        }
        return true;
    }

    public Predicate<T> getPredicate() {
        return this.predicate;
    }
}

