/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime.ability.execute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.hifforce.lattice.extension.ExtensionRunner;
import org.hifforce.lattice.message.Message;
import org.hifforce.lattice.model.register.TemplateSpec;
import org.hiforce.lattice.runtime.ability.execute.RunnerExecutionStatus;

public class ExecuteResult<R> {
    private String extCode;
    private boolean success;
    private String errCode;
    private String errLogText;
    private String errText;
    private R result;
    private String reduceName;
    private final List<RunnerExecutionStatus> detailResults = new ArrayList<RunnerExecutionStatus>(10);
    private static final ExtensionRunner.CollectionRunnerExecuteResult DUMMY = new ExtensionRunner.CollectionRunnerExecuteResult();

    public static <T> ExecuteResult<T> failed(String extCode, Message message) {
        ExecuteResult result = new ExecuteResult();
        result.extCode = extCode;
        result.errCode = message.getCode();
        result.errLogText = message.getText();
        result.errText = message.getDisplayText();
        return result;
    }

    public static <T> ExecuteResult<T> success(String extCode, String reduceName, Message message) {
        ExecuteResult<Object> result = new ExecuteResult<Object>();
        result.extCode = extCode;
        result.success = true;
        result.reduceName = reduceName;
        result.setResult(null);
        result.extCode = extCode;
        result.errCode = message.getCode();
        result.errLogText = message.getText();
        result.errText = message.getDisplayText();
        return result;
    }

    public static <T> ExecuteResult<T> success(String extCode, String reduceName, T model, List<TemplateSpec> runners, List<ExtensionRunner.CollectionRunnerExecuteResult> executeResults) {
        ExecuteResult<T> result = new ExecuteResult<T>();
        result.extCode = extCode;
        result.success = true;
        result.reduceName = reduceName;
        result.setResult(model);
        if (CollectionUtils.isNotEmpty(runners)) {
            int totalLen = executeResults.size();
            for (int i = 0; i < runners.size(); ++i) {
                if (i < totalLen) {
                    result.detailResults.add(ExecuteResult.toRunnerExecutionStatus(runners.get(i), executeResults.get(i)));
                    continue;
                }
                result.detailResults.add(ExecuteResult.toRunnerExecutionStatus(runners.get(i), DUMMY));
            }
        }
        return result;
    }

    private static RunnerExecutionStatus toRunnerExecutionStatus(TemplateSpec runner, ExtensionRunner.CollectionRunnerExecuteResult executeResult) {
        RunnerExecutionStatus status = new RunnerExecutionStatus();
        if (null != runner) {
            status.setTemplateCode(runner.getCode());
            status.setTemplateType(runner.getType());
        }
        status.setExecuted(executeResult.isExecute());
        status.setInvokeResults(executeResult.getResults());
        status.setType(executeResult.getRunnerType());
        return status;
    }

    public String getExtCode() {
        return this.extCode;
    }

    public void setExtCode(String extCode) {
        this.extCode = extCode;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getErrCode() {
        return this.errCode;
    }

    public String getErrLogText() {
        return this.errLogText;
    }

    public String getErrText() {
        return this.errText;
    }

    public R getResult() {
        return this.result;
    }

    public void setResult(R result) {
        this.result = result;
    }

    public String getReduceName() {
        return this.reduceName;
    }

    public List<RunnerExecutionStatus> getDetailResults() {
        return this.detailResults;
    }

    static {
        DUMMY.setResults(Collections.emptyList());
    }
}

