/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime.ability.reduce;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.hifforce.lattice.annotation.model.ReduceType;
import org.hifforce.lattice.model.ability.execute.Reducer;

public class FirstOf<T>
extends Reducer<T, T> {
    private Predicate<T> predicate;

    public FirstOf(@Nonnull Predicate<T> predicate) {
        Objects.requireNonNull(predicate);
        this.predicate = predicate;
    }

    public FirstOf() {
    }

    public boolean willBreak(Collection<T> elements) {
        if (CollectionUtils.isEmpty(elements)) {
            return false;
        }
        for (T element : elements) {
            if (null != this.predicate && !this.predicate.test(element)) continue;
            this.setResult(element);
            this.setBreak();
            return true;
        }
        return false;
    }

    public ReduceType reducerType() {
        return ReduceType.FIRST;
    }

    @Nullable
    public T reduce(Collection<T> elements) {
        if (this.isHasBreak()) {
            return (T)this.getResult();
        }
        if (CollectionUtils.isEmpty(elements)) {
            return null;
        }
        for (T element : elements) {
            if (null == this.predicate) {
                return element;
            }
            if (!this.predicate.test(element)) continue;
            return element;
        }
        return null;
    }
}

