/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime.session;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.hifforce.lattice.cache.invoke.InvokeCache;
import org.hifforce.lattice.exception.LatticeRuntimeException;
import org.hifforce.lattice.model.business.IBizObject;
import org.hifforce.lattice.model.business.ITemplate;
import org.hifforce.lattice.model.config.BusinessConfig;
import org.hifforce.lattice.model.context.BizSessionContext;
import org.hifforce.lattice.model.register.ProductSpec;
import org.hifforce.lattice.model.register.TemplateSpec;
import org.hifforce.lattice.model.register.UseCaseSpec;
import org.hifforce.lattice.model.scenario.ScenarioRequest;
import org.hiforce.lattice.runtime.Lattice;
import org.hiforce.lattice.runtime.session.Scope;

public abstract class BizSessionScope<Resp, BizObject extends IBizObject>
extends Scope<Resp> {
    private final List<BizObject> bizObjects = Lists.newArrayList();
    private final List<ScenarioRequest> scenarioRequests = Lists.newArrayList();
    private BizSessionContext context;
    private boolean invokeCacheInit;

    public BizSessionScope(List<BizObject> bizObjects) {
        if (CollectionUtils.isEmpty(bizObjects)) {
            throw new LatticeRuntimeException("LATTICE-CORE-RT-0010", new Object[0]);
        }
        this.bizObjects.addAll(bizObjects);
    }

    public BizSessionScope(BizObject bizObject) {
        if (null == bizObject) {
            throw new LatticeRuntimeException("LATTICE-CORE-RT-0010", new Object[0]);
        }
        this.bizObjects.add(bizObject);
    }

    public abstract ScenarioRequest buildScenarioRequest(BizObject var1);

    @Override
    protected void entrance() {
        this.invokeCacheInit = InvokeCache.isThreadLocalInit();
        if (!this.invokeCacheInit) {
            InvokeCache.initInvokeCache();
        }
        this.context = (BizSessionContext)BizSessionContext.SESSION_CONTEXT_THREAD_LOCAL.get();
        InvokeCache.instance().put(BizSessionContext.class, BizSessionContext.class, (Object)this.context);
        this.initScenarioRequest();
        this.buildEffectProducts();
    }

    private void buildEffectProducts() {
        for (ScenarioRequest request : this.scenarioRequests) {
            ArrayList templates = Lists.newArrayList();
            templates.addAll(this.loadEffectiveUseCases(request));
            templates.addAll(this.loadBusinessInstalledProducts(request.getBizObject().getBizCode()).stream().filter(p -> this.isTemplateEffective((TemplateSpec)p, request)).collect(Collectors.toList()));
            templates.sort(Comparator.comparingInt(TemplateSpec::getPriority));
            this.context.getEffectiveTemplates().put(request.getBizObject().getBizCode(), templates);
        }
    }

    private List<UseCaseSpec> loadEffectiveUseCases(ScenarioRequest request) {
        return Lattice.getInstance().getAllRegisteredUseCases().stream().filter(p -> this.isTemplateEffective((TemplateSpec)p, request)).collect(Collectors.toList());
    }

    private boolean isTemplateEffective(TemplateSpec templateSpec, ScenarioRequest request) {
        if (null == templateSpec) {
            return false;
        }
        ITemplate template = templateSpec.newInstance();
        if (null == template) {
            return false;
        }
        return template.isEffect(request);
    }

    private List<ProductSpec> loadBusinessInstalledProducts(String bizCode) {
        if (StringUtils.isEmpty((CharSequence)bizCode)) {
            throw new LatticeRuntimeException("LATTICE-CORE-RT-0014", new Object[]{bizCode});
        }
        BusinessConfig businessConfig = Lattice.getInstance().getBusinessConfigByBizCode(bizCode);
        if (null == businessConfig) {
            if (Lattice.getInstance().isSimpleMode()) {
                return Lattice.getInstance().getAllRegisteredProducts();
            }
            throw new LatticeRuntimeException("LATTICE-CORE-RT-0012", new Object[]{bizCode});
        }
        Set productConfigs = businessConfig.getProducts();
        return productConfigs.stream().map(p -> Lattice.getInstance().getRegisteredProductByCode(p.getCode())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private void initScenarioRequest() {
        for (IBizObject bizObject : this.bizObjects) {
            ScenarioRequest request = this.buildScenarioRequest(bizObject);
            if (null == request) {
                throw new LatticeRuntimeException("LATTICE-CORE-RT-0011", new Object[0]);
            }
            this.scenarioRequests.add(request);
        }
    }

    @Override
    protected void exit() {
        if (!this.invokeCacheInit) {
            InvokeCache.forceClear();
        }
        BizSessionContext.SESSION_CONTEXT_THREAD_LOCAL.set(null);
        BizSessionContext.SESSION_CONTEXT_THREAD_LOCAL.remove();
    }

    @Override
    protected Scope.Entrance getEntrance() {
        return BizSessionScope.newEntrance();
    }

    public List<BizObject> getBizObjects() {
        return this.bizObjects;
    }

    public BizSessionContext getContext() {
        return this.context;
    }
}

