/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime.ability.execute.runner;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.hifforce.lattice.extension.ExtensionRunner;
import org.hifforce.lattice.extension.ExtensionRunnerType;
import org.hifforce.lattice.message.Message;
import org.hifforce.lattice.model.ability.IBusinessExt;
import org.hifforce.lattice.model.ability.execute.ExtensionCallback;
import org.hifforce.lattice.model.business.IBizObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionJavaRunner<R>
extends ExtensionRunner<R> {
    private static final Logger log = LoggerFactory.getLogger(ExtensionJavaRunner.class);

    public R runFirstMatched(IBizObject bizObject, ExtensionCallback<IBusinessExt, R> callback, ExtensionRunner.RunnerExecuteResult executeResult) {
        if (null == this.getModel()) {
            log.warn(Message.code((String)"LATTICE-CORE-RT-0009", (Object[])new Object[]{this.getExtensionCode()}).toString());
            return null;
        }
        executeResult.setExecute(true);
        executeResult.setRunnerType(this.getType());
        return (R)callback.apply(this.getModel());
    }

    public ExtensionJavaRunner(String extensionCode, IBusinessExt model) {
        super(extensionCode, model);
    }

    @Nonnull
    public List<R> runAllMatched(IBizObject bizObject, ExtensionCallback<IBusinessExt, R> callback, ExtensionRunner.RunnerExecuteResult executeResult) {
        return Collections.singletonList(this.runFirstMatched(bizObject, callback, executeResult));
    }

    public ExtensionRunnerType getType() {
        return ExtensionRunnerType.JAVA;
    }
}

