/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.test.scenario.order.impl;

import org.hifforce.lattice.exception.LatticeRuntimeException;
import org.hiforce.lattice.runtime.session.BizSessionScope;
import org.hiforce.lattice.test.ability.SampleAbility;
import org.hiforce.lattice.test.model.OrderLine;
import org.hiforce.lattice.test.scenario.order.PlaceOrderService;
import org.hiforce.lattice.test.scenario.order.param.PlaceOrderReqDTO;
import org.hiforce.lattice.test.scenario.order.param.PlaceOrderRespDTO;
import org.hiforce.lattice.test.scenario.order.result.PlaceOrderRequest;
import org.hiforce.lattice.test.scenario.order.result.ShoppingResult;

public class PlaceOrderRemoteService
implements PlaceOrderService {
    @Override
    public PlaceOrderRespDTO createOrder(PlaceOrderReqDTO reqDTO) {
        final OrderLine orderLine = new OrderLine();
        orderLine.setBizCode("business.a");
        orderLine.setScenario(reqDTO.getScenario());
        orderLine.setItemId(reqDTO.getItemId());
        orderLine.setBuyerId(reqDTO.getBuyerId());
        orderLine.setBuyQuantity(reqDTO.getBuyQuantity());
        try {
            ShoppingResult result = (ShoppingResult)new BizSessionScope<ShoppingResult, OrderLine>(orderLine){

                protected ShoppingResult execute() throws LatticeRuntimeException {
                    ShoppingResult shoppingResult = new ShoppingResult();
                    SampleAbility ability = new SampleAbility(orderLine);
                    String value = ability.invokeTheSampleSampleExtensionPoint_01();
                    shoppingResult.setExtResult(value);
                    return shoppingResult;
                }

                public PlaceOrderRequest buildScenarioRequest(OrderLine bizObject) {
                    PlaceOrderRequest request = new PlaceOrderRequest(bizObject);
                    return request;
                }
            }.invoke();
            PlaceOrderRespDTO respDTO = PlaceOrderRespDTO.success();
            respDTO.setResult(result.getExtResult());
            return respDTO;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return PlaceOrderRespDTO.failed("ERR_SOME_CODE", "Create Order Failed.");
        }
    }
}

