/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.chrome.devtools.domains.inspector;

import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.Flow;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.internal.UnitSerializer;
import org.hildan.chrome.devtools.domains.inspector.DisableResponse;
import org.hildan.chrome.devtools.domains.inspector.EnableResponse;
import org.hildan.chrome.devtools.domains.inspector.events.InspectorEvent;
import org.hildan.chrome.devtools.protocol.ChromeDPSession;
import org.hildan.chrome.devtools.protocol.ExperimentalChromeApi;
import org.hildan.chrome.devtools.protocol.SessionSerializationKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ExperimentalChromeApi
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0007J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0011\u0010\u000e\u001a\u00020\u000fH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\u0011\u0010\u0011\u001a\u00020\u0012H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u000bJ\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000bH\u0007J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u000bJ\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000bH\u0007J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u000bR \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001a"}, d2={"Lorg/hildan/chrome/devtools/domains/inspector/InspectorDomain;", "", "session", "Lorg/hildan/chrome/devtools/protocol/ChromeDPSession;", "(Lorg/hildan/chrome/devtools/protocol/ChromeDPSession;)V", "deserializersByEventName", "", "", "Lkotlinx/serialization/DeserializationStrategy;", "Lorg/hildan/chrome/devtools/domains/inspector/events/InspectorEvent;", "detached", "Lkotlinx/coroutines/flow/Flow;", "Lorg/hildan/chrome/devtools/domains/inspector/events/InspectorEvent$Detached;", "detachedEvents", "disable", "Lorg/hildan/chrome/devtools/domains/inspector/DisableResponse;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "enable", "Lorg/hildan/chrome/devtools/domains/inspector/EnableResponse;", "events", "targetCrashed", "Lorg/hildan/chrome/devtools/domains/inspector/events/InspectorEvent$TargetCrashed;", "targetCrashedEvents", "targetReloadedAfterCrash", "Lorg/hildan/chrome/devtools/domains/inspector/events/InspectorEvent$TargetReloadedAfterCrash;", "targetReloadedAfterCrashEvents", "chrome-devtools-kotlin"})
@SourceDebugExtension(value={"SMAP\nInspectorDomain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InspectorDomain.kt\norg/hildan/chrome/devtools/domains/inspector/InspectorDomain\n+ 2 SessionSerialization.kt\norg/hildan/chrome/devtools/protocol/SessionSerializationKt\n*L\n1#1,119:1\n39#2,2:120\n39#2,2:122\n39#2,2:124\n18#2:126\n18#2:127\n*S KotlinDebug\n*F\n+ 1 InspectorDomain.kt\norg/hildan/chrome/devtools/domains/inspector/InspectorDomain\n*L\n68#1:120,2\n82#1:122,2\n96#1:124,2\n110#1:126\n117#1:127\n*E\n"})
public final class InspectorDomain {
    @NotNull
    private final ChromeDPSession session;
    @NotNull
    private final Map<String, DeserializationStrategy<InspectorEvent>> deserializersByEventName;

    public InspectorDomain(@NotNull ChromeDPSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Inspector.detached", InspectorEvent.Detached.Companion.serializer()), TuplesKt.to((Object)"Inspector.targetCrashed", InspectorEvent.TargetCrashed.INSTANCE.serializer()), TuplesKt.to((Object)"Inspector.targetReloadedAfterCrash", InspectorEvent.TargetReloadedAfterCrash.INSTANCE.serializer())};
        this.deserializersByEventName = MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public final Flow<InspectorEvent> events() {
        return SessionSerializationKt.typedEvents(this.session, this.deserializersByEventName);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Flow<InspectorEvent.Detached> detachedEvents() {
        void $this$typedEvents$iv;
        ChromeDPSession chromeDPSession = this.session;
        String eventName$iv = "Inspector.detached";
        boolean $i$f$typedEvents = false;
        return SessionSerializationKt.typedEvents((ChromeDPSession)$this$typedEvents$iv, eventName$iv, (DeserializationStrategy)InspectorEvent.Detached.Companion.serializer());
    }

    @Deprecated(message="Events subscription methods were renamed with the -Events suffix.", replaceWith=@ReplaceWith(expression="detachedEvents()", imports={}))
    @NotNull
    public final Flow<InspectorEvent.Detached> detached() {
        return this.detachedEvents();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Flow<InspectorEvent.TargetCrashed> targetCrashedEvents() {
        void $this$typedEvents$iv;
        ChromeDPSession chromeDPSession = this.session;
        String eventName$iv = "Inspector.targetCrashed";
        boolean $i$f$typedEvents = false;
        return SessionSerializationKt.typedEvents((ChromeDPSession)$this$typedEvents$iv, eventName$iv, (DeserializationStrategy)InspectorEvent.TargetCrashed.INSTANCE.serializer());
    }

    @Deprecated(message="Events subscription methods were renamed with the -Events suffix.", replaceWith=@ReplaceWith(expression="targetCrashedEvents()", imports={}))
    @NotNull
    public final Flow<InspectorEvent.TargetCrashed> targetCrashed() {
        return this.targetCrashedEvents();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Flow<InspectorEvent.TargetReloadedAfterCrash> targetReloadedAfterCrashEvents() {
        void $this$typedEvents$iv;
        ChromeDPSession chromeDPSession = this.session;
        String eventName$iv = "Inspector.targetReloadedAfterCrash";
        boolean $i$f$typedEvents = false;
        return SessionSerializationKt.typedEvents((ChromeDPSession)$this$typedEvents$iv, eventName$iv, (DeserializationStrategy)InspectorEvent.TargetReloadedAfterCrash.INSTANCE.serializer());
    }

    @Deprecated(message="Events subscription methods were renamed with the -Events suffix.", replaceWith=@ReplaceWith(expression="targetReloadedAfterCrashEvents()", imports={}))
    @NotNull
    public final Flow<InspectorEvent.TargetReloadedAfterCrash> targetReloadedAfterCrash() {
        return this.targetReloadedAfterCrashEvents();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object disable(@NotNull Continuation<? super DisableResponse> $completion) {
        void methodName$iv;
        void $this$request$iv;
        ChromeDPSession chromeDPSession = this.session;
        String string = "Inspector.disable";
        Unit requestParams$iv = Unit.INSTANCE;
        boolean $i$f$request = false;
        return SessionSerializationKt.request((ChromeDPSession)$this$request$iv, (String)methodName$iv, requestParams$iv, (SerializationStrategy)UnitSerializer.INSTANCE, (DeserializationStrategy)DisableResponse.INSTANCE.serializer(), $completion);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object enable(@NotNull Continuation<? super EnableResponse> $completion) {
        void methodName$iv;
        void $this$request$iv;
        ChromeDPSession chromeDPSession = this.session;
        String string = "Inspector.enable";
        Unit requestParams$iv = Unit.INSTANCE;
        boolean $i$f$request = false;
        return SessionSerializationKt.request((ChromeDPSession)$this$request$iv, (String)methodName$iv, requestParams$iv, (SerializationStrategy)UnitSerializer.INSTANCE, (DeserializationStrategy)EnableResponse.INSTANCE.serializer(), $completion);
    }
}

