/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.chrome.devtools.domains.log;

import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.Flow;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.internal.UnitSerializer;
import org.hildan.chrome.devtools.domains.log.ClearResponse;
import org.hildan.chrome.devtools.domains.log.DisableResponse;
import org.hildan.chrome.devtools.domains.log.EnableResponse;
import org.hildan.chrome.devtools.domains.log.StartViolationsReportRequest;
import org.hildan.chrome.devtools.domains.log.StartViolationsReportResponse;
import org.hildan.chrome.devtools.domains.log.StopViolationsReportResponse;
import org.hildan.chrome.devtools.domains.log.ViolationSetting;
import org.hildan.chrome.devtools.domains.log.events.LogEvent;
import org.hildan.chrome.devtools.protocol.ChromeDPSession;
import org.hildan.chrome.devtools.protocol.SessionSerializationKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\n\u001a\u00020\u000bH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ\u0011\u0010\r\u001a\u00020\u000eH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ\u0011\u0010\u000f\u001a\u00020\u0010H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0007J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u0012J\u001f\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ\u0019\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001eJ\u0011\u0010\u001f\u001a\u00020 H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fR \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006!"}, d2={"Lorg/hildan/chrome/devtools/domains/log/LogDomain;", "", "session", "Lorg/hildan/chrome/devtools/protocol/ChromeDPSession;", "(Lorg/hildan/chrome/devtools/protocol/ChromeDPSession;)V", "deserializersByEventName", "", "", "Lkotlinx/serialization/DeserializationStrategy;", "Lorg/hildan/chrome/devtools/domains/log/events/LogEvent;", "clear", "Lorg/hildan/chrome/devtools/domains/log/ClearResponse;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "disable", "Lorg/hildan/chrome/devtools/domains/log/DisableResponse;", "enable", "Lorg/hildan/chrome/devtools/domains/log/EnableResponse;", "entryAdded", "Lkotlinx/coroutines/flow/Flow;", "Lorg/hildan/chrome/devtools/domains/log/events/LogEvent$EntryAdded;", "entryAddedEvents", "events", "startViolationsReport", "Lorg/hildan/chrome/devtools/domains/log/StartViolationsReportResponse;", "config", "", "Lorg/hildan/chrome/devtools/domains/log/ViolationSetting;", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "input", "Lorg/hildan/chrome/devtools/domains/log/StartViolationsReportRequest;", "(Lorg/hildan/chrome/devtools/domains/log/StartViolationsReportRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stopViolationsReport", "Lorg/hildan/chrome/devtools/domains/log/StopViolationsReportResponse;", "chrome-devtools-kotlin"})
@SourceDebugExtension(value={"SMAP\nLogDomain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogDomain.kt\norg/hildan/chrome/devtools/domains/log/LogDomain\n+ 2 SessionSerialization.kt\norg/hildan/chrome/devtools/protocol/SessionSerializationKt\n*L\n1#1,165:1\n39#2,2:166\n18#2:168\n18#2:169\n18#2:170\n18#2:171\n18#2:172\n*S KotlinDebug\n*F\n+ 1 LogDomain.kt\norg/hildan/chrome/devtools/domains/log/LogDomain\n*L\n101#1:166,2\n114#1:168\n121#1:169\n129#1:170\n142#1:171\n163#1:172\n*E\n"})
public final class LogDomain {
    @NotNull
    private final ChromeDPSession session;
    @NotNull
    private final Map<String, DeserializationStrategy<LogEvent>> deserializersByEventName;

    public LogDomain(@NotNull ChromeDPSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        this.deserializersByEventName = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Log.entryAdded", LogEvent.EntryAdded.Companion.serializer()));
    }

    @NotNull
    public final Flow<LogEvent> events() {
        return SessionSerializationKt.typedEvents(this.session, this.deserializersByEventName);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Flow<LogEvent.EntryAdded> entryAddedEvents() {
        void $this$typedEvents$iv;
        ChromeDPSession chromeDPSession = this.session;
        String eventName$iv = "Log.entryAdded";
        boolean $i$f$typedEvents = false;
        return SessionSerializationKt.typedEvents((ChromeDPSession)$this$typedEvents$iv, eventName$iv, (DeserializationStrategy)LogEvent.EntryAdded.Companion.serializer());
    }

    @Deprecated(message="Events subscription methods were renamed with the -Events suffix.", replaceWith=@ReplaceWith(expression="entryAddedEvents()", imports={}))
    @NotNull
    public final Flow<LogEvent.EntryAdded> entryAdded() {
        return this.entryAddedEvents();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object clear(@NotNull Continuation<? super ClearResponse> $completion) {
        void methodName$iv;
        void $this$request$iv;
        ChromeDPSession chromeDPSession = this.session;
        String string = "Log.clear";
        Unit requestParams$iv = Unit.INSTANCE;
        boolean $i$f$request = false;
        return SessionSerializationKt.request((ChromeDPSession)$this$request$iv, (String)methodName$iv, requestParams$iv, (SerializationStrategy)UnitSerializer.INSTANCE, (DeserializationStrategy)ClearResponse.INSTANCE.serializer(), $completion);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object disable(@NotNull Continuation<? super DisableResponse> $completion) {
        void methodName$iv;
        void $this$request$iv;
        ChromeDPSession chromeDPSession = this.session;
        String string = "Log.disable";
        Unit requestParams$iv = Unit.INSTANCE;
        boolean $i$f$request = false;
        return SessionSerializationKt.request((ChromeDPSession)$this$request$iv, (String)methodName$iv, requestParams$iv, (SerializationStrategy)UnitSerializer.INSTANCE, (DeserializationStrategy)DisableResponse.INSTANCE.serializer(), $completion);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object enable(@NotNull Continuation<? super EnableResponse> $completion) {
        void methodName$iv;
        void $this$request$iv;
        ChromeDPSession chromeDPSession = this.session;
        String string = "Log.enable";
        Unit requestParams$iv = Unit.INSTANCE;
        boolean $i$f$request = false;
        return SessionSerializationKt.request((ChromeDPSession)$this$request$iv, (String)methodName$iv, requestParams$iv, (SerializationStrategy)UnitSerializer.INSTANCE, (DeserializationStrategy)EnableResponse.INSTANCE.serializer(), $completion);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object startViolationsReport(@NotNull StartViolationsReportRequest input2, @NotNull Continuation<? super StartViolationsReportResponse> $completion) {
        void $this$request$iv;
        ChromeDPSession chromeDPSession = this.session;
        String methodName$iv = "Log.startViolationsReport";
        boolean $i$f$request = false;
        return SessionSerializationKt.request((ChromeDPSession)$this$request$iv, methodName$iv, input2, (SerializationStrategy)StartViolationsReportRequest.Companion.serializer(), (DeserializationStrategy)StartViolationsReportResponse.INSTANCE.serializer(), $completion);
    }

    @Nullable
    public final Object startViolationsReport(@NotNull List<ViolationSetting> config, @NotNull Continuation<? super StartViolationsReportResponse> $completion) {
        StartViolationsReportRequest input2 = new StartViolationsReportRequest(config);
        return this.startViolationsReport(input2, $completion);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object stopViolationsReport(@NotNull Continuation<? super StopViolationsReportResponse> $completion) {
        void methodName$iv;
        void $this$request$iv;
        ChromeDPSession chromeDPSession = this.session;
        String string = "Log.stopViolationsReport";
        Unit requestParams$iv = Unit.INSTANCE;
        boolean $i$f$request = false;
        return SessionSerializationKt.request((ChromeDPSession)$this$request$iv, (String)methodName$iv, requestParams$iv, (SerializationStrategy)UnitSerializer.INSTANCE, (DeserializationStrategy)StopViolationsReportResponse.INSTANCE.serializer(), $completion);
    }
}

