/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.chrome.devtools.domains.tethering;

import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.Flow;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import org.hildan.chrome.devtools.domains.tethering.BindRequest;
import org.hildan.chrome.devtools.domains.tethering.BindResponse;
import org.hildan.chrome.devtools.domains.tethering.UnbindRequest;
import org.hildan.chrome.devtools.domains.tethering.UnbindResponse;
import org.hildan.chrome.devtools.domains.tethering.events.TetheringEvent;
import org.hildan.chrome.devtools.protocol.ChromeDPSession;
import org.hildan.chrome.devtools.protocol.ExperimentalChromeApi;
import org.hildan.chrome.devtools.protocol.SessionSerializationKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ExperimentalChromeApi
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0007J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0019\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J\u0019\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u000bJ\u0019\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0011H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J\u0019\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0019H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001aR \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001b"}, d2={"Lorg/hildan/chrome/devtools/domains/tethering/TetheringDomain;", "", "session", "Lorg/hildan/chrome/devtools/protocol/ChromeDPSession;", "(Lorg/hildan/chrome/devtools/protocol/ChromeDPSession;)V", "deserializersByEventName", "", "", "Lkotlinx/serialization/DeserializationStrategy;", "Lorg/hildan/chrome/devtools/domains/tethering/events/TetheringEvent;", "accepted", "Lkotlinx/coroutines/flow/Flow;", "Lorg/hildan/chrome/devtools/domains/tethering/events/TetheringEvent$Accepted;", "acceptedEvents", "bind", "Lorg/hildan/chrome/devtools/domains/tethering/BindResponse;", "port", "", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "input", "Lorg/hildan/chrome/devtools/domains/tethering/BindRequest;", "(Lorg/hildan/chrome/devtools/domains/tethering/BindRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "events", "unbind", "Lorg/hildan/chrome/devtools/domains/tethering/UnbindResponse;", "Lorg/hildan/chrome/devtools/domains/tethering/UnbindRequest;", "(Lorg/hildan/chrome/devtools/domains/tethering/UnbindRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "chrome-devtools-kotlin"})
@SourceDebugExtension(value={"SMAP\nTetheringDomain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TetheringDomain.kt\norg/hildan/chrome/devtools/domains/tethering/TetheringDomain\n+ 2 SessionSerialization.kt\norg/hildan/chrome/devtools/protocol/SessionSerializationKt\n*L\n1#1,147:1\n39#2,2:148\n18#2:150\n18#2:151\n*S KotlinDebug\n*F\n+ 1 TetheringDomain.kt\norg/hildan/chrome/devtools/domains/tethering/TetheringDomain\n*L\n89#1:148,2\n107#1:150\n133#1:151\n*E\n"})
public final class TetheringDomain {
    @NotNull
    private final ChromeDPSession session;
    @NotNull
    private final Map<String, DeserializationStrategy<TetheringEvent>> deserializersByEventName;

    public TetheringDomain(@NotNull ChromeDPSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        this.deserializersByEventName = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Tethering.accepted", TetheringEvent.Accepted.Companion.serializer()));
    }

    @NotNull
    public final Flow<TetheringEvent> events() {
        return SessionSerializationKt.typedEvents(this.session, this.deserializersByEventName);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Flow<TetheringEvent.Accepted> acceptedEvents() {
        void $this$typedEvents$iv;
        ChromeDPSession chromeDPSession = this.session;
        String eventName$iv = "Tethering.accepted";
        boolean $i$f$typedEvents = false;
        return SessionSerializationKt.typedEvents((ChromeDPSession)$this$typedEvents$iv, eventName$iv, (DeserializationStrategy)TetheringEvent.Accepted.Companion.serializer());
    }

    @Deprecated(message="Events subscription methods were renamed with the -Events suffix.", replaceWith=@ReplaceWith(expression="acceptedEvents()", imports={}))
    @NotNull
    public final Flow<TetheringEvent.Accepted> accepted() {
        return this.acceptedEvents();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object bind(@NotNull BindRequest input2, @NotNull Continuation<? super BindResponse> $completion) {
        void $this$request$iv;
        ChromeDPSession chromeDPSession = this.session;
        String methodName$iv = "Tethering.bind";
        boolean $i$f$request = false;
        return SessionSerializationKt.request((ChromeDPSession)$this$request$iv, methodName$iv, input2, (SerializationStrategy)BindRequest.Companion.serializer(), (DeserializationStrategy)BindResponse.INSTANCE.serializer(), $completion);
    }

    @Nullable
    public final Object bind(int port, @NotNull Continuation<? super BindResponse> $completion) {
        BindRequest input2 = new BindRequest(port);
        return this.bind(input2, $completion);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object unbind(@NotNull UnbindRequest input2, @NotNull Continuation<? super UnbindResponse> $completion) {
        void $this$request$iv;
        ChromeDPSession chromeDPSession = this.session;
        String methodName$iv = "Tethering.unbind";
        boolean $i$f$request = false;
        return SessionSerializationKt.request((ChromeDPSession)$this$request$iv, methodName$iv, input2, (SerializationStrategy)UnbindRequest.Companion.serializer(), (DeserializationStrategy)UnbindResponse.INSTANCE.serializer(), $completion);
    }

    @Nullable
    public final Object unbind(int port, @NotNull Continuation<? super UnbindResponse> $completion) {
        UnbindRequest input2 = new UnbindRequest(port);
        return this.unbind(input2, $completion);
    }
}

