/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.chrome.devtools.domains.media;

import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.Flow;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.internal.UnitSerializer;
import org.hildan.chrome.devtools.domains.media.DisableResponse;
import org.hildan.chrome.devtools.domains.media.EnableResponse;
import org.hildan.chrome.devtools.domains.media.events.MediaEvent;
import org.hildan.chrome.devtools.protocol.ChromeDPSession;
import org.hildan.chrome.devtools.protocol.ExperimentalChromeApi;
import org.hildan.chrome.devtools.protocol.SessionSerializationKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ExperimentalChromeApi
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\n\u001a\u00020\u000bH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ\u0011\u0010\r\u001a\u00020\u000eH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u0010J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0010H\u0007J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0010J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0010H\u0007J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0010J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0010H\u0007J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u0010J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0010H\u0007J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0010J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0010H\u0007J\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0010R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006 "}, d2={"Lorg/hildan/chrome/devtools/domains/media/MediaDomain;", "", "session", "Lorg/hildan/chrome/devtools/protocol/ChromeDPSession;", "(Lorg/hildan/chrome/devtools/protocol/ChromeDPSession;)V", "deserializersByEventName", "", "", "Lkotlinx/serialization/DeserializationStrategy;", "Lorg/hildan/chrome/devtools/domains/media/events/MediaEvent;", "disable", "Lorg/hildan/chrome/devtools/domains/media/DisableResponse;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "enable", "Lorg/hildan/chrome/devtools/domains/media/EnableResponse;", "events", "Lkotlinx/coroutines/flow/Flow;", "playerErrorsRaised", "Lorg/hildan/chrome/devtools/domains/media/events/MediaEvent$PlayerErrorsRaised;", "playerErrorsRaisedEvents", "playerEventsAdded", "Lorg/hildan/chrome/devtools/domains/media/events/MediaEvent$PlayerEventsAdded;", "playerEventsAddedEvents", "playerMessagesLogged", "Lorg/hildan/chrome/devtools/domains/media/events/MediaEvent$PlayerMessagesLogged;", "playerMessagesLoggedEvents", "playerPropertiesChanged", "Lorg/hildan/chrome/devtools/domains/media/events/MediaEvent$PlayerPropertiesChanged;", "playerPropertiesChangedEvents", "playersCreated", "Lorg/hildan/chrome/devtools/domains/media/events/MediaEvent$PlayersCreated;", "playersCreatedEvents", "chrome-devtools-kotlin"})
@SourceDebugExtension(value={"SMAP\nMediaDomain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MediaDomain.kt\norg/hildan/chrome/devtools/domains/media/MediaDomain\n+ 2 SessionSerialization.kt\norg/hildan/chrome/devtools/protocol/SessionSerializationKt\n*L\n1#1,153:1\n39#2,2:154\n39#2,2:156\n39#2,2:158\n39#2,2:160\n39#2,2:162\n18#2:164\n18#2:165\n*S KotlinDebug\n*F\n+ 1 MediaDomain.kt\norg/hildan/chrome/devtools/domains/media/MediaDomain\n*L\n70#1:154,2\n86#1:156,2\n100#1:158,2\n115#1:160,2\n131#1:162,2\n144#1:164\n151#1:165\n*E\n"})
public final class MediaDomain {
    @NotNull
    private final ChromeDPSession session;
    @NotNull
    private final Map<String, DeserializationStrategy<MediaEvent>> deserializersByEventName;

    public MediaDomain(@NotNull ChromeDPSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Media.playerPropertiesChanged", MediaEvent.PlayerPropertiesChanged.Companion.serializer()), TuplesKt.to((Object)"Media.playerEventsAdded", MediaEvent.PlayerEventsAdded.Companion.serializer()), TuplesKt.to((Object)"Media.playerMessagesLogged", MediaEvent.PlayerMessagesLogged.Companion.serializer()), TuplesKt.to((Object)"Media.playerErrorsRaised", MediaEvent.PlayerErrorsRaised.Companion.serializer()), TuplesKt.to((Object)"Media.playersCreated", MediaEvent.PlayersCreated.Companion.serializer())};
        this.deserializersByEventName = MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public final Flow<MediaEvent> events() {
        return SessionSerializationKt.typedEvents(this.session, this.deserializersByEventName);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Flow<MediaEvent.PlayerPropertiesChanged> playerPropertiesChangedEvents() {
        void $this$typedEvents$iv;
        ChromeDPSession chromeDPSession = this.session;
        String eventName$iv = "Media.playerPropertiesChanged";
        boolean $i$f$typedEvents = false;
        return SessionSerializationKt.typedEvents((ChromeDPSession)$this$typedEvents$iv, eventName$iv, (DeserializationStrategy)MediaEvent.PlayerPropertiesChanged.Companion.serializer());
    }

    @Deprecated(message="Events subscription methods were renamed with the -Events suffix.", replaceWith=@ReplaceWith(expression="playerPropertiesChangedEvents()", imports={}))
    @NotNull
    public final Flow<MediaEvent.PlayerPropertiesChanged> playerPropertiesChanged() {
        return this.playerPropertiesChangedEvents();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Flow<MediaEvent.PlayerEventsAdded> playerEventsAddedEvents() {
        void $this$typedEvents$iv;
        ChromeDPSession chromeDPSession = this.session;
        String eventName$iv = "Media.playerEventsAdded";
        boolean $i$f$typedEvents = false;
        return SessionSerializationKt.typedEvents((ChromeDPSession)$this$typedEvents$iv, eventName$iv, (DeserializationStrategy)MediaEvent.PlayerEventsAdded.Companion.serializer());
    }

    @Deprecated(message="Events subscription methods were renamed with the -Events suffix.", replaceWith=@ReplaceWith(expression="playerEventsAddedEvents()", imports={}))
    @NotNull
    public final Flow<MediaEvent.PlayerEventsAdded> playerEventsAdded() {
        return this.playerEventsAddedEvents();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Flow<MediaEvent.PlayerMessagesLogged> playerMessagesLoggedEvents() {
        void $this$typedEvents$iv;
        ChromeDPSession chromeDPSession = this.session;
        String eventName$iv = "Media.playerMessagesLogged";
        boolean $i$f$typedEvents = false;
        return SessionSerializationKt.typedEvents((ChromeDPSession)$this$typedEvents$iv, eventName$iv, (DeserializationStrategy)MediaEvent.PlayerMessagesLogged.Companion.serializer());
    }

    @Deprecated(message="Events subscription methods were renamed with the -Events suffix.", replaceWith=@ReplaceWith(expression="playerMessagesLoggedEvents()", imports={}))
    @NotNull
    public final Flow<MediaEvent.PlayerMessagesLogged> playerMessagesLogged() {
        return this.playerMessagesLoggedEvents();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Flow<MediaEvent.PlayerErrorsRaised> playerErrorsRaisedEvents() {
        void $this$typedEvents$iv;
        ChromeDPSession chromeDPSession = this.session;
        String eventName$iv = "Media.playerErrorsRaised";
        boolean $i$f$typedEvents = false;
        return SessionSerializationKt.typedEvents((ChromeDPSession)$this$typedEvents$iv, eventName$iv, (DeserializationStrategy)MediaEvent.PlayerErrorsRaised.Companion.serializer());
    }

    @Deprecated(message="Events subscription methods were renamed with the -Events suffix.", replaceWith=@ReplaceWith(expression="playerErrorsRaisedEvents()", imports={}))
    @NotNull
    public final Flow<MediaEvent.PlayerErrorsRaised> playerErrorsRaised() {
        return this.playerErrorsRaisedEvents();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Flow<MediaEvent.PlayersCreated> playersCreatedEvents() {
        void $this$typedEvents$iv;
        ChromeDPSession chromeDPSession = this.session;
        String eventName$iv = "Media.playersCreated";
        boolean $i$f$typedEvents = false;
        return SessionSerializationKt.typedEvents((ChromeDPSession)$this$typedEvents$iv, eventName$iv, (DeserializationStrategy)MediaEvent.PlayersCreated.Companion.serializer());
    }

    @Deprecated(message="Events subscription methods were renamed with the -Events suffix.", replaceWith=@ReplaceWith(expression="playersCreatedEvents()", imports={}))
    @NotNull
    public final Flow<MediaEvent.PlayersCreated> playersCreated() {
        return this.playersCreatedEvents();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object enable(@NotNull Continuation<? super EnableResponse> $completion) {
        void methodName$iv;
        void $this$request$iv;
        ChromeDPSession chromeDPSession = this.session;
        String string = "Media.enable";
        Unit requestParams$iv = Unit.INSTANCE;
        boolean $i$f$request = false;
        return SessionSerializationKt.request((ChromeDPSession)$this$request$iv, (String)methodName$iv, requestParams$iv, (SerializationStrategy)UnitSerializer.INSTANCE, (DeserializationStrategy)EnableResponse.INSTANCE.serializer(), $completion);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object disable(@NotNull Continuation<? super DisableResponse> $completion) {
        void methodName$iv;
        void $this$request$iv;
        ChromeDPSession chromeDPSession = this.session;
        String string = "Media.disable";
        Unit requestParams$iv = Unit.INSTANCE;
        boolean $i$f$request = false;
        return SessionSerializationKt.request((ChromeDPSession)$this$request$iv, (String)methodName$iv, requestParams$iv, (SerializationStrategy)UnitSerializer.INSTANCE, (DeserializationStrategy)DisableResponse.INSTANCE.serializer(), $completion);
    }
}

