/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.chrome.devtools.domains.log;

import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.Flow;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.internal.UnitSerializer;
import org.hildan.chrome.devtools.domains.log.ClearResponse;
import org.hildan.chrome.devtools.domains.log.DisableResponse;
import org.hildan.chrome.devtools.domains.log.EnableResponse;
import org.hildan.chrome.devtools.domains.log.StartViolationsReportRequest;
import org.hildan.chrome.devtools.domains.log.StartViolationsReportResponse;
import org.hildan.chrome.devtools.domains.log.StopViolationsReportResponse;
import org.hildan.chrome.devtools.domains.log.ViolationSetting;
import org.hildan.chrome.devtools.domains.log.events.LogEvent;
import org.hildan.chrome.devtools.protocol.ChromeDPSession;
import org.hildan.chrome.devtools.protocol.SessionSerializationKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\fJ\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\fH\u0007J\u000e\u0010\u0010\u001a\u00020\u0011H\u0086@\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\u0013\u001a\u00020\u0014H\u0086@\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\u0015\u001a\u00020\u0016H\u0086@\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0086@\u00a2\u0006\u0002\u0010\u001bJ\u001c\u0010\u0017\u001a\u00020\u00182\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0086@\u00a2\u0006\u0002\u0010\u001fJ\u000e\u0010 \u001a\u00020!H\u0086@\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/hildan/chrome/devtools/domains/log/LogDomain;", "", "session", "Lorg/hildan/chrome/devtools/protocol/ChromeDPSession;", "<init>", "(Lorg/hildan/chrome/devtools/protocol/ChromeDPSession;)V", "deserializersByEventName", "", "", "Lkotlinx/serialization/DeserializationStrategy;", "Lorg/hildan/chrome/devtools/domains/log/events/LogEvent;", "events", "Lkotlinx/coroutines/flow/Flow;", "entryAddedEvents", "Lorg/hildan/chrome/devtools/domains/log/events/LogEvent$EntryAdded;", "entryAdded", "clear", "Lorg/hildan/chrome/devtools/domains/log/ClearResponse;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "disable", "Lorg/hildan/chrome/devtools/domains/log/DisableResponse;", "enable", "Lorg/hildan/chrome/devtools/domains/log/EnableResponse;", "startViolationsReport", "Lorg/hildan/chrome/devtools/domains/log/StartViolationsReportResponse;", "input", "Lorg/hildan/chrome/devtools/domains/log/StartViolationsReportRequest;", "(Lorg/hildan/chrome/devtools/domains/log/StartViolationsReportRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "config", "", "Lorg/hildan/chrome/devtools/domains/log/ViolationSetting;", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stopViolationsReport", "Lorg/hildan/chrome/devtools/domains/log/StopViolationsReportResponse;", "chrome-devtools-kotlin"})
@SourceDebugExtension(value={"SMAP\nLogDomain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogDomain.kt\norg/hildan/chrome/devtools/domains/log/LogDomain\n+ 2 SessionSerialization.kt\norg/hildan/chrome/devtools/protocol/SessionSerializationKt\n*L\n1#1,165:1\n39#2,2:166\n18#2:168\n18#2:169\n18#2:170\n18#2:171\n18#2:172\n*S KotlinDebug\n*F\n+ 1 LogDomain.kt\norg/hildan/chrome/devtools/domains/log/LogDomain\n*L\n101#1:166,2\n114#1:168\n121#1:169\n129#1:170\n142#1:171\n163#1:172\n*E\n"})
public final class LogDomain {
    @NotNull
    private final ChromeDPSession session;
    @NotNull
    private final Map<String, DeserializationStrategy<LogEvent>> deserializersByEventName;

    public LogDomain(@NotNull ChromeDPSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        this.deserializersByEventName = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Log.entryAdded", LogEvent.EntryAdded.Companion.serializer()));
    }

    @NotNull
    public final Flow<LogEvent> events() {
        return SessionSerializationKt.typedEvents(this.session, this.deserializersByEventName);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Flow<LogEvent.EntryAdded> entryAddedEvents() {
        void $this$typedEvents$iv;
        ChromeDPSession chromeDPSession = this.session;
        String eventName$iv = "Log.entryAdded";
        boolean $i$f$typedEvents = false;
        return SessionSerializationKt.typedEvents((ChromeDPSession)$this$typedEvents$iv, eventName$iv, (DeserializationStrategy)LogEvent.EntryAdded.Companion.serializer());
    }

    @Deprecated(message="Events subscription methods were renamed with the -Events suffix.", replaceWith=@ReplaceWith(expression="entryAddedEvents()", imports={}))
    @NotNull
    public final Flow<LogEvent.EntryAdded> entryAdded() {
        return this.entryAddedEvents();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object clear(@NotNull Continuation<? super ClearResponse> $completion) {
        void methodName$iv;
        void $this$request$iv;
        ChromeDPSession chromeDPSession = this.session;
        String string = "Log.clear";
        Unit requestParams$iv = Unit.INSTANCE;
        boolean $i$f$request = false;
        return SessionSerializationKt.request((ChromeDPSession)$this$request$iv, (String)methodName$iv, requestParams$iv, (SerializationStrategy)UnitSerializer.INSTANCE, (DeserializationStrategy)ClearResponse.INSTANCE.serializer(), $completion);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object disable(@NotNull Continuation<? super DisableResponse> $completion) {
        void methodName$iv;
        void $this$request$iv;
        ChromeDPSession chromeDPSession = this.session;
        String string = "Log.disable";
        Unit requestParams$iv = Unit.INSTANCE;
        boolean $i$f$request = false;
        return SessionSerializationKt.request((ChromeDPSession)$this$request$iv, (String)methodName$iv, requestParams$iv, (SerializationStrategy)UnitSerializer.INSTANCE, (DeserializationStrategy)DisableResponse.INSTANCE.serializer(), $completion);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object enable(@NotNull Continuation<? super EnableResponse> $completion) {
        void methodName$iv;
        void $this$request$iv;
        ChromeDPSession chromeDPSession = this.session;
        String string = "Log.enable";
        Unit requestParams$iv = Unit.INSTANCE;
        boolean $i$f$request = false;
        return SessionSerializationKt.request((ChromeDPSession)$this$request$iv, (String)methodName$iv, requestParams$iv, (SerializationStrategy)UnitSerializer.INSTANCE, (DeserializationStrategy)EnableResponse.INSTANCE.serializer(), $completion);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object startViolationsReport(@NotNull StartViolationsReportRequest input, @NotNull Continuation<? super StartViolationsReportResponse> $completion) {
        void $this$request$iv;
        ChromeDPSession chromeDPSession = this.session;
        String methodName$iv = "Log.startViolationsReport";
        boolean $i$f$request = false;
        return SessionSerializationKt.request((ChromeDPSession)$this$request$iv, methodName$iv, input, (SerializationStrategy)StartViolationsReportRequest.Companion.serializer(), (DeserializationStrategy)StartViolationsReportResponse.INSTANCE.serializer(), $completion);
    }

    @Nullable
    public final Object startViolationsReport(@NotNull List<ViolationSetting> config, @NotNull Continuation<? super StartViolationsReportResponse> $completion) {
        StartViolationsReportRequest input = new StartViolationsReportRequest(config);
        return this.startViolationsReport(input, $completion);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object stopViolationsReport(@NotNull Continuation<? super StopViolationsReportResponse> $completion) {
        void methodName$iv;
        void $this$request$iv;
        ChromeDPSession chromeDPSession = this.session;
        String string = "Log.stopViolationsReport";
        Unit requestParams$iv = Unit.INSTANCE;
        boolean $i$f$request = false;
        return SessionSerializationKt.request((ChromeDPSession)$this$request$iv, (String)methodName$iv, requestParams$iv, (SerializationStrategy)UnitSerializer.INSTANCE, (DeserializationStrategy)StopViolationsReportResponse.INSTANCE.serializer(), $completion);
    }
}

