/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.chrome.devtools.domains.media;

import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.Flow;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.internal.UnitSerializer;
import org.hildan.chrome.devtools.domains.media.DisableResponse;
import org.hildan.chrome.devtools.domains.media.EnableResponse;
import org.hildan.chrome.devtools.domains.media.events.MediaEvent;
import org.hildan.chrome.devtools.protocol.ChromeDPSession;
import org.hildan.chrome.devtools.protocol.ExperimentalChromeApi;
import org.hildan.chrome.devtools.protocol.SessionSerializationKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ExperimentalChromeApi
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\fJ\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\fH\u0007J\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\fJ\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\fH\u0007J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\fJ\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\fH\u0007J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\fJ\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\fH\u0007J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\fJ\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\fH\u0007J\u000e\u0010\u001c\u001a\u00020\u001dH\u0086@\u00a2\u0006\u0002\u0010\u001eJ\u000e\u0010\u001f\u001a\u00020 H\u0086@\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/hildan/chrome/devtools/domains/media/MediaDomain;", "", "session", "Lorg/hildan/chrome/devtools/protocol/ChromeDPSession;", "<init>", "(Lorg/hildan/chrome/devtools/protocol/ChromeDPSession;)V", "deserializersByEventName", "", "", "Lkotlinx/serialization/DeserializationStrategy;", "Lorg/hildan/chrome/devtools/domains/media/events/MediaEvent;", "events", "Lkotlinx/coroutines/flow/Flow;", "playerPropertiesChangedEvents", "Lorg/hildan/chrome/devtools/domains/media/events/MediaEvent$PlayerPropertiesChanged;", "playerPropertiesChanged", "playerEventsAddedEvents", "Lorg/hildan/chrome/devtools/domains/media/events/MediaEvent$PlayerEventsAdded;", "playerEventsAdded", "playerMessagesLoggedEvents", "Lorg/hildan/chrome/devtools/domains/media/events/MediaEvent$PlayerMessagesLogged;", "playerMessagesLogged", "playerErrorsRaisedEvents", "Lorg/hildan/chrome/devtools/domains/media/events/MediaEvent$PlayerErrorsRaised;", "playerErrorsRaised", "playersCreatedEvents", "Lorg/hildan/chrome/devtools/domains/media/events/MediaEvent$PlayersCreated;", "playersCreated", "enable", "Lorg/hildan/chrome/devtools/domains/media/EnableResponse;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "disable", "Lorg/hildan/chrome/devtools/domains/media/DisableResponse;", "chrome-devtools-kotlin"})
@SourceDebugExtension(value={"SMAP\nMediaDomain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MediaDomain.kt\norg/hildan/chrome/devtools/domains/media/MediaDomain\n+ 2 SessionSerialization.kt\norg/hildan/chrome/devtools/protocol/SessionSerializationKt\n*L\n1#1,139:1\n39#2,2:140\n39#2,2:142\n39#2,2:144\n39#2,2:146\n39#2,2:148\n18#2:150\n18#2:151\n*S KotlinDebug\n*F\n+ 1 MediaDomain.kt\norg/hildan/chrome/devtools/domains/media/MediaDomain\n*L\n62#1:140,2\n76#1:142,2\n89#1:144,2\n102#1:146,2\n117#1:148,2\n130#1:150\n137#1:151\n*E\n"})
public final class MediaDomain {
    @NotNull
    private final ChromeDPSession session;
    @NotNull
    private final Map<String, DeserializationStrategy<MediaEvent>> deserializersByEventName;

    public MediaDomain(@NotNull ChromeDPSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Media.playerPropertiesChanged", MediaEvent.PlayerPropertiesChanged.Companion.serializer()), TuplesKt.to((Object)"Media.playerEventsAdded", MediaEvent.PlayerEventsAdded.Companion.serializer()), TuplesKt.to((Object)"Media.playerMessagesLogged", MediaEvent.PlayerMessagesLogged.Companion.serializer()), TuplesKt.to((Object)"Media.playerErrorsRaised", MediaEvent.PlayerErrorsRaised.Companion.serializer()), TuplesKt.to((Object)"Media.playersCreated", MediaEvent.PlayersCreated.Companion.serializer())};
        this.deserializersByEventName = MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public final Flow<MediaEvent> events() {
        return SessionSerializationKt.typedEvents(this.session, this.deserializersByEventName);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Flow<MediaEvent.PlayerPropertiesChanged> playerPropertiesChangedEvents() {
        void $this$typedEvents$iv;
        ChromeDPSession chromeDPSession = this.session;
        String eventName$iv = "Media.playerPropertiesChanged";
        boolean $i$f$typedEvents = false;
        return SessionSerializationKt.typedEvents((ChromeDPSession)$this$typedEvents$iv, eventName$iv, (DeserializationStrategy)MediaEvent.PlayerPropertiesChanged.Companion.serializer());
    }

    @Deprecated(message="Events subscription methods were renamed with the -Events suffix.", replaceWith=@ReplaceWith(expression="playerPropertiesChangedEvents()", imports={}))
    @NotNull
    public final Flow<MediaEvent.PlayerPropertiesChanged> playerPropertiesChanged() {
        return this.playerPropertiesChangedEvents();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Flow<MediaEvent.PlayerEventsAdded> playerEventsAddedEvents() {
        void $this$typedEvents$iv;
        ChromeDPSession chromeDPSession = this.session;
        String eventName$iv = "Media.playerEventsAdded";
        boolean $i$f$typedEvents = false;
        return SessionSerializationKt.typedEvents((ChromeDPSession)$this$typedEvents$iv, eventName$iv, (DeserializationStrategy)MediaEvent.PlayerEventsAdded.Companion.serializer());
    }

    @Deprecated(message="Events subscription methods were renamed with the -Events suffix.", replaceWith=@ReplaceWith(expression="playerEventsAddedEvents()", imports={}))
    @NotNull
    public final Flow<MediaEvent.PlayerEventsAdded> playerEventsAdded() {
        return this.playerEventsAddedEvents();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Flow<MediaEvent.PlayerMessagesLogged> playerMessagesLoggedEvents() {
        void $this$typedEvents$iv;
        ChromeDPSession chromeDPSession = this.session;
        String eventName$iv = "Media.playerMessagesLogged";
        boolean $i$f$typedEvents = false;
        return SessionSerializationKt.typedEvents((ChromeDPSession)$this$typedEvents$iv, eventName$iv, (DeserializationStrategy)MediaEvent.PlayerMessagesLogged.Companion.serializer());
    }

    @Deprecated(message="Events subscription methods were renamed with the -Events suffix.", replaceWith=@ReplaceWith(expression="playerMessagesLoggedEvents()", imports={}))
    @NotNull
    public final Flow<MediaEvent.PlayerMessagesLogged> playerMessagesLogged() {
        return this.playerMessagesLoggedEvents();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Flow<MediaEvent.PlayerErrorsRaised> playerErrorsRaisedEvents() {
        void $this$typedEvents$iv;
        ChromeDPSession chromeDPSession = this.session;
        String eventName$iv = "Media.playerErrorsRaised";
        boolean $i$f$typedEvents = false;
        return SessionSerializationKt.typedEvents((ChromeDPSession)$this$typedEvents$iv, eventName$iv, (DeserializationStrategy)MediaEvent.PlayerErrorsRaised.Companion.serializer());
    }

    @Deprecated(message="Events subscription methods were renamed with the -Events suffix.", replaceWith=@ReplaceWith(expression="playerErrorsRaisedEvents()", imports={}))
    @NotNull
    public final Flow<MediaEvent.PlayerErrorsRaised> playerErrorsRaised() {
        return this.playerErrorsRaisedEvents();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Flow<MediaEvent.PlayersCreated> playersCreatedEvents() {
        void $this$typedEvents$iv;
        ChromeDPSession chromeDPSession = this.session;
        String eventName$iv = "Media.playersCreated";
        boolean $i$f$typedEvents = false;
        return SessionSerializationKt.typedEvents((ChromeDPSession)$this$typedEvents$iv, eventName$iv, (DeserializationStrategy)MediaEvent.PlayersCreated.Companion.serializer());
    }

    @Deprecated(message="Events subscription methods were renamed with the -Events suffix.", replaceWith=@ReplaceWith(expression="playersCreatedEvents()", imports={}))
    @NotNull
    public final Flow<MediaEvent.PlayersCreated> playersCreated() {
        return this.playersCreatedEvents();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object enable(@NotNull Continuation<? super EnableResponse> $completion) {
        void methodName$iv;
        void $this$request$iv;
        ChromeDPSession chromeDPSession = this.session;
        String string = "Media.enable";
        Unit requestParams$iv = Unit.INSTANCE;
        boolean $i$f$request = false;
        return SessionSerializationKt.request((ChromeDPSession)$this$request$iv, (String)methodName$iv, requestParams$iv, (SerializationStrategy)UnitSerializer.INSTANCE, (DeserializationStrategy)EnableResponse.INSTANCE.serializer(), $completion);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object disable(@NotNull Continuation<? super DisableResponse> $completion) {
        void methodName$iv;
        void $this$request$iv;
        ChromeDPSession chromeDPSession = this.session;
        String string = "Media.disable";
        Unit requestParams$iv = Unit.INSTANCE;
        boolean $i$f$request = false;
        return SessionSerializationKt.request((ChromeDPSession)$this$request$iv, (String)methodName$iv, requestParams$iv, (SerializationStrategy)UnitSerializer.INSTANCE, (DeserializationStrategy)DisableResponse.INSTANCE.serializer(), $completion);
    }
}

