/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.chrome.devtools.domains.security;

import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.Flow;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.internal.UnitSerializer;
import org.hildan.chrome.devtools.domains.security.CertificateErrorAction;
import org.hildan.chrome.devtools.domains.security.DisableResponse;
import org.hildan.chrome.devtools.domains.security.EnableResponse;
import org.hildan.chrome.devtools.domains.security.HandleCertificateErrorRequest;
import org.hildan.chrome.devtools.domains.security.HandleCertificateErrorResponse;
import org.hildan.chrome.devtools.domains.security.SetIgnoreCertificateErrorsRequest;
import org.hildan.chrome.devtools.domains.security.SetIgnoreCertificateErrorsResponse;
import org.hildan.chrome.devtools.domains.security.SetOverrideCertificateErrorsRequest;
import org.hildan.chrome.devtools.domains.security.SetOverrideCertificateErrorsResponse;
import org.hildan.chrome.devtools.domains.security.events.SecurityEvent;
import org.hildan.chrome.devtools.protocol.ChromeDPSession;
import org.hildan.chrome.devtools.protocol.ExperimentalChromeApi;
import org.hildan.chrome.devtools.protocol.SessionSerializationKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\fH\u0007J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\fH\u0007J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\fH\u0007J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\fH\u0007J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\fH\u0007J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\fH\u0007J\u000e\u0010\u0016\u001a\u00020\u0017H\u0086@\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u0019\u001a\u00020\u001aH\u0086@\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0086@\u00a2\u0006\u0002\u0010\u001fJ\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!H\u0086@\u00a2\u0006\u0002\u0010\"J\u0016\u0010#\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020%H\u0087@\u00a2\u0006\u0002\u0010&J\u001e\u0010#\u001a\u00020$2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0087@\u00a2\u0006\u0002\u0010+J\u0016\u0010,\u001a\u00020-2\u0006\u0010\u001d\u001a\u00020.H\u0087@\u00a2\u0006\u0002\u0010/J\u0016\u0010,\u001a\u00020-2\u0006\u00100\u001a\u00020!H\u0087@\u00a2\u0006\u0002\u0010\"R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/hildan/chrome/devtools/domains/security/SecurityDomain;", "", "session", "Lorg/hildan/chrome/devtools/protocol/ChromeDPSession;", "<init>", "(Lorg/hildan/chrome/devtools/protocol/ChromeDPSession;)V", "deserializersByEventName", "", "", "Lkotlinx/serialization/DeserializationStrategy;", "Lorg/hildan/chrome/devtools/domains/security/events/SecurityEvent;", "events", "Lkotlinx/coroutines/flow/Flow;", "certificateErrorEvents", "Lorg/hildan/chrome/devtools/domains/security/events/SecurityEvent$CertificateError;", "certificateError", "visibleSecurityStateChangedEvents", "Lorg/hildan/chrome/devtools/domains/security/events/SecurityEvent$VisibleSecurityStateChanged;", "visibleSecurityStateChanged", "securityStateChangedEvents", "Lorg/hildan/chrome/devtools/domains/security/events/SecurityEvent$SecurityStateChanged;", "securityStateChanged", "disable", "Lorg/hildan/chrome/devtools/domains/security/DisableResponse;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "enable", "Lorg/hildan/chrome/devtools/domains/security/EnableResponse;", "setIgnoreCertificateErrors", "Lorg/hildan/chrome/devtools/domains/security/SetIgnoreCertificateErrorsResponse;", "input", "Lorg/hildan/chrome/devtools/domains/security/SetIgnoreCertificateErrorsRequest;", "(Lorg/hildan/chrome/devtools/domains/security/SetIgnoreCertificateErrorsRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ignore", "", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleCertificateError", "Lorg/hildan/chrome/devtools/domains/security/HandleCertificateErrorResponse;", "Lorg/hildan/chrome/devtools/domains/security/HandleCertificateErrorRequest;", "(Lorg/hildan/chrome/devtools/domains/security/HandleCertificateErrorRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "eventId", "", "action", "Lorg/hildan/chrome/devtools/domains/security/CertificateErrorAction;", "(ILorg/hildan/chrome/devtools/domains/security/CertificateErrorAction;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setOverrideCertificateErrors", "Lorg/hildan/chrome/devtools/domains/security/SetOverrideCertificateErrorsResponse;", "Lorg/hildan/chrome/devtools/domains/security/SetOverrideCertificateErrorsRequest;", "(Lorg/hildan/chrome/devtools/domains/security/SetOverrideCertificateErrorsRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "override", "chrome-devtools-kotlin"})
@SourceDebugExtension(value={"SMAP\nSecurityDomain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SecurityDomain.kt\norg/hildan/chrome/devtools/domains/security/SecurityDomain\n+ 2 SessionSerialization.kt\norg/hildan/chrome/devtools/protocol/SessionSerializationKt\n*L\n1#1,243:1\n39#2,2:244\n39#2,2:246\n39#2,2:248\n18#2:250\n18#2:251\n18#2:252\n18#2:253\n18#2:254\n*S KotlinDebug\n*F\n+ 1 SecurityDomain.kt\norg/hildan/chrome/devtools/domains/security/SecurityDomain\n*L\n123#1:244,2\n137#1:246,2\n151#1:248,2\n164#1:250\n171#1:251\n180#1:252\n202#1:253\n227#1:254\n*E\n"})
public final class SecurityDomain {
    @NotNull
    private final ChromeDPSession session;
    @NotNull
    private final Map<String, DeserializationStrategy<SecurityEvent>> deserializersByEventName;

    public SecurityDomain(@NotNull ChromeDPSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Security.certificateError", SecurityEvent.CertificateError.Companion.serializer()), TuplesKt.to((Object)"Security.visibleSecurityStateChanged", SecurityEvent.VisibleSecurityStateChanged.Companion.serializer()), TuplesKt.to((Object)"Security.securityStateChanged", SecurityEvent.SecurityStateChanged.Companion.serializer())};
        this.deserializersByEventName = MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public final Flow<SecurityEvent> events() {
        return SessionSerializationKt.typedEvents(this.session, this.deserializersByEventName);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="Deprecated in the Chrome DevTools protocol")
    @NotNull
    public final Flow<SecurityEvent.CertificateError> certificateErrorEvents() {
        void $this$typedEvents$iv;
        ChromeDPSession chromeDPSession = this.session;
        String eventName$iv = "Security.certificateError";
        boolean $i$f$typedEvents = false;
        return SessionSerializationKt.typedEvents((ChromeDPSession)$this$typedEvents$iv, eventName$iv, (DeserializationStrategy)SecurityEvent.CertificateError.Companion.serializer());
    }

    @Deprecated(message="Events subscription methods were renamed with the -Events suffix.", replaceWith=@ReplaceWith(expression="certificateErrorEvents()", imports={}))
    @NotNull
    public final Flow<SecurityEvent.CertificateError> certificateError() {
        return this.certificateErrorEvents();
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalChromeApi
    @NotNull
    public final Flow<SecurityEvent.VisibleSecurityStateChanged> visibleSecurityStateChangedEvents() {
        void $this$typedEvents$iv;
        ChromeDPSession chromeDPSession = this.session;
        String eventName$iv = "Security.visibleSecurityStateChanged";
        boolean $i$f$typedEvents = false;
        return SessionSerializationKt.typedEvents((ChromeDPSession)$this$typedEvents$iv, eventName$iv, (DeserializationStrategy)SecurityEvent.VisibleSecurityStateChanged.Companion.serializer());
    }

    @Deprecated(message="Events subscription methods were renamed with the -Events suffix.", replaceWith=@ReplaceWith(expression="visibleSecurityStateChangedEvents()", imports={}))
    @NotNull
    public final Flow<SecurityEvent.VisibleSecurityStateChanged> visibleSecurityStateChanged() {
        return this.visibleSecurityStateChangedEvents();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="Deprecated in the Chrome DevTools protocol")
    @NotNull
    public final Flow<SecurityEvent.SecurityStateChanged> securityStateChangedEvents() {
        void $this$typedEvents$iv;
        ChromeDPSession chromeDPSession = this.session;
        String eventName$iv = "Security.securityStateChanged";
        boolean $i$f$typedEvents = false;
        return SessionSerializationKt.typedEvents((ChromeDPSession)$this$typedEvents$iv, eventName$iv, (DeserializationStrategy)SecurityEvent.SecurityStateChanged.Companion.serializer());
    }

    @Deprecated(message="Events subscription methods were renamed with the -Events suffix.", replaceWith=@ReplaceWith(expression="securityStateChangedEvents()", imports={}))
    @NotNull
    public final Flow<SecurityEvent.SecurityStateChanged> securityStateChanged() {
        return this.securityStateChangedEvents();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object disable(@NotNull Continuation<? super DisableResponse> $completion) {
        void methodName$iv;
        void $this$request$iv;
        ChromeDPSession chromeDPSession = this.session;
        String string = "Security.disable";
        Unit requestParams$iv = Unit.INSTANCE;
        boolean $i$f$request = false;
        return SessionSerializationKt.request((ChromeDPSession)$this$request$iv, (String)methodName$iv, requestParams$iv, (SerializationStrategy)UnitSerializer.INSTANCE, (DeserializationStrategy)DisableResponse.INSTANCE.serializer(), $completion);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object enable(@NotNull Continuation<? super EnableResponse> $completion) {
        void methodName$iv;
        void $this$request$iv;
        ChromeDPSession chromeDPSession = this.session;
        String string = "Security.enable";
        Unit requestParams$iv = Unit.INSTANCE;
        boolean $i$f$request = false;
        return SessionSerializationKt.request((ChromeDPSession)$this$request$iv, (String)methodName$iv, requestParams$iv, (SerializationStrategy)UnitSerializer.INSTANCE, (DeserializationStrategy)EnableResponse.INSTANCE.serializer(), $completion);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object setIgnoreCertificateErrors(@NotNull SetIgnoreCertificateErrorsRequest input, @NotNull Continuation<? super SetIgnoreCertificateErrorsResponse> $completion) {
        void $this$request$iv;
        ChromeDPSession chromeDPSession = this.session;
        String methodName$iv = "Security.setIgnoreCertificateErrors";
        boolean $i$f$request = false;
        return SessionSerializationKt.request((ChromeDPSession)$this$request$iv, methodName$iv, input, (SerializationStrategy)SetIgnoreCertificateErrorsRequest.Companion.serializer(), (DeserializationStrategy)SetIgnoreCertificateErrorsResponse.INSTANCE.serializer(), $completion);
    }

    @Nullable
    public final Object setIgnoreCertificateErrors(boolean ignore, @NotNull Continuation<? super SetIgnoreCertificateErrorsResponse> $completion) {
        SetIgnoreCertificateErrorsRequest input = new SetIgnoreCertificateErrorsRequest(ignore);
        return this.setIgnoreCertificateErrors(input, $completion);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="Deprecated in the Chrome DevTools protocol")
    @Nullable
    public final Object handleCertificateError(@NotNull HandleCertificateErrorRequest input, @NotNull Continuation<? super HandleCertificateErrorResponse> $completion) {
        void $this$request$iv;
        ChromeDPSession chromeDPSession = this.session;
        String methodName$iv = "Security.handleCertificateError";
        boolean $i$f$request = false;
        return SessionSerializationKt.request((ChromeDPSession)$this$request$iv, methodName$iv, input, (SerializationStrategy)HandleCertificateErrorRequest.Companion.serializer(), (DeserializationStrategy)HandleCertificateErrorResponse.INSTANCE.serializer(), $completion);
    }

    @Deprecated(message="Deprecated in the Chrome DevTools protocol")
    @Nullable
    public final Object handleCertificateError(int eventId, @NotNull CertificateErrorAction action, @NotNull Continuation<? super HandleCertificateErrorResponse> $completion) {
        HandleCertificateErrorRequest input = new HandleCertificateErrorRequest(eventId, action);
        return this.handleCertificateError(input, $completion);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="Deprecated in the Chrome DevTools protocol")
    @Nullable
    public final Object setOverrideCertificateErrors(@NotNull SetOverrideCertificateErrorsRequest input, @NotNull Continuation<? super SetOverrideCertificateErrorsResponse> $completion) {
        void $this$request$iv;
        ChromeDPSession chromeDPSession = this.session;
        String methodName$iv = "Security.setOverrideCertificateErrors";
        boolean $i$f$request = false;
        return SessionSerializationKt.request((ChromeDPSession)$this$request$iv, methodName$iv, input, (SerializationStrategy)SetOverrideCertificateErrorsRequest.Companion.serializer(), (DeserializationStrategy)SetOverrideCertificateErrorsResponse.INSTANCE.serializer(), $completion);
    }

    @Deprecated(message="Deprecated in the Chrome DevTools protocol")
    @Nullable
    public final Object setOverrideCertificateErrors(boolean override, @NotNull Continuation<? super SetOverrideCertificateErrorsResponse> $completion) {
        SetOverrideCertificateErrorsRequest input = new SetOverrideCertificateErrorsRequest(override);
        return this.setOverrideCertificateErrors(input, $completion);
    }
}

