/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.chrome.devtools.domains.debugger;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.hildan.chrome.devtools.domains.debugger.ScriptSourceStatus;
import org.hildan.chrome.devtools.protocol.FCEnumSerializer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lorg/hildan/chrome/devtools/domains/debugger/ScriptSourceStatusSerializer;", "Lorg/hildan/chrome/devtools/protocol/FCEnumSerializer;", "Lorg/hildan/chrome/devtools/domains/debugger/ScriptSourceStatus;", "<init>", "()V", "fromCode", "code", "", "codeOf", "value", "chrome-devtools-kotlin"})
final class ScriptSourceStatusSerializer
extends FCEnumSerializer<ScriptSourceStatus> {
    @NotNull
    public static final ScriptSourceStatusSerializer INSTANCE = new ScriptSourceStatusSerializer();

    private ScriptSourceStatusSerializer() {
        super(Reflection.getOrCreateKotlinClass(ScriptSourceStatus.class));
    }

    @Override
    @NotNull
    public ScriptSourceStatus fromCode(@NotNull String code) {
        ScriptSourceStatus scriptSourceStatus;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        switch (code) {
            case "Ok": {
                scriptSourceStatus = ScriptSourceStatus.Ok.INSTANCE;
                break;
            }
            case "CompileError": {
                scriptSourceStatus = ScriptSourceStatus.CompileError.INSTANCE;
                break;
            }
            case "BlockedByActiveGenerator": {
                scriptSourceStatus = ScriptSourceStatus.BlockedByActiveGenerator.INSTANCE;
                break;
            }
            case "BlockedByActiveFunction": {
                scriptSourceStatus = ScriptSourceStatus.BlockedByActiveFunction.INSTANCE;
                break;
            }
            case "BlockedByTopLevelEsModuleChange": {
                scriptSourceStatus = ScriptSourceStatus.BlockedByTopLevelEsModuleChange.INSTANCE;
                break;
            }
            default: {
                scriptSourceStatus = new ScriptSourceStatus.NotDefinedInProtocol(code);
            }
        }
        return scriptSourceStatus;
    }

    @Override
    @NotNull
    public String codeOf(@NotNull ScriptSourceStatus value) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ScriptSourceStatus scriptSourceStatus = value;
        if (scriptSourceStatus instanceof ScriptSourceStatus.Ok) {
            string2 = "Ok";
        } else if (scriptSourceStatus instanceof ScriptSourceStatus.CompileError) {
            string2 = "CompileError";
        } else if (scriptSourceStatus instanceof ScriptSourceStatus.BlockedByActiveGenerator) {
            string2 = "BlockedByActiveGenerator";
        } else if (scriptSourceStatus instanceof ScriptSourceStatus.BlockedByActiveFunction) {
            string2 = "BlockedByActiveFunction";
        } else if (scriptSourceStatus instanceof ScriptSourceStatus.BlockedByTopLevelEsModuleChange) {
            string2 = "BlockedByTopLevelEsModuleChange";
        } else if (scriptSourceStatus instanceof ScriptSourceStatus.NotDefinedInProtocol) {
            string2 = ((ScriptSourceStatus.NotDefinedInProtocol)value).getValue();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }
}

