/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.chrome.devtools.domains.headlessexperimental;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.hildan.chrome.devtools.domains.headlessexperimental.ImageFormat;
import org.hildan.chrome.devtools.protocol.FCEnumSerializer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lorg/hildan/chrome/devtools/domains/headlessexperimental/ImageFormatSerializer;", "Lorg/hildan/chrome/devtools/protocol/FCEnumSerializer;", "Lorg/hildan/chrome/devtools/domains/headlessexperimental/ImageFormat;", "<init>", "()V", "fromCode", "code", "", "codeOf", "value", "chrome-devtools-kotlin"})
final class ImageFormatSerializer
extends FCEnumSerializer<ImageFormat> {
    @NotNull
    public static final ImageFormatSerializer INSTANCE = new ImageFormatSerializer();

    private ImageFormatSerializer() {
        super(Reflection.getOrCreateKotlinClass(ImageFormat.class));
    }

    @Override
    @NotNull
    public ImageFormat fromCode(@NotNull String code) {
        ImageFormat imageFormat;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        switch (code) {
            case "jpeg": {
                imageFormat = ImageFormat.jpeg.INSTANCE;
                break;
            }
            case "png": {
                imageFormat = ImageFormat.png.INSTANCE;
                break;
            }
            case "webp": {
                imageFormat = ImageFormat.webp.INSTANCE;
                break;
            }
            default: {
                imageFormat = new ImageFormat.NotDefinedInProtocol(code);
            }
        }
        return imageFormat;
    }

    @Override
    @NotNull
    public String codeOf(@NotNull ImageFormat value) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ImageFormat imageFormat = value;
        if (imageFormat instanceof ImageFormat.jpeg) {
            string2 = "jpeg";
        } else if (imageFormat instanceof ImageFormat.png) {
            string2 = "png";
        } else if (imageFormat instanceof ImageFormat.webp) {
            string2 = "webp";
        } else if (imageFormat instanceof ImageFormat.NotDefinedInProtocol) {
            string2 = ((ImageFormat.NotDefinedInProtocol)value).getValue();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }
}

