/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.chrome.devtools.domains.indexeddb;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.hildan.chrome.devtools.domains.indexeddb.KeyType;
import org.hildan.chrome.devtools.protocol.FCEnumSerializer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lorg/hildan/chrome/devtools/domains/indexeddb/KeyTypeSerializer;", "Lorg/hildan/chrome/devtools/protocol/FCEnumSerializer;", "Lorg/hildan/chrome/devtools/domains/indexeddb/KeyType;", "<init>", "()V", "fromCode", "code", "", "codeOf", "value", "chrome-devtools-kotlin"})
final class KeyTypeSerializer
extends FCEnumSerializer<KeyType> {
    @NotNull
    public static final KeyTypeSerializer INSTANCE = new KeyTypeSerializer();

    private KeyTypeSerializer() {
        super(Reflection.getOrCreateKotlinClass(KeyType.class));
    }

    @Override
    @NotNull
    public KeyType fromCode(@NotNull String code) {
        KeyType keyType;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        switch (code) {
            case "number": {
                keyType = KeyType.number.INSTANCE;
                break;
            }
            case "string": {
                keyType = KeyType.string.INSTANCE;
                break;
            }
            case "date": {
                keyType = KeyType.date.INSTANCE;
                break;
            }
            case "array": {
                keyType = KeyType.array.INSTANCE;
                break;
            }
            default: {
                keyType = new KeyType.NotDefinedInProtocol(code);
            }
        }
        return keyType;
    }

    @Override
    @NotNull
    public String codeOf(@NotNull KeyType value) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        KeyType keyType = value;
        if (keyType instanceof KeyType.number) {
            string2 = "number";
        } else if (keyType instanceof KeyType.string) {
            string2 = "string";
        } else if (keyType instanceof KeyType.date) {
            string2 = "date";
        } else if (keyType instanceof KeyType.array) {
            string2 = "array";
        } else if (keyType instanceof KeyType.NotDefinedInProtocol) {
            string2 = ((KeyType.NotDefinedInProtocol)value).getValue();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }
}

