/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.chrome.devtools.domains.inspector;

import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.Flow;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.internal.UnitSerializer;
import org.hildan.chrome.devtools.domains.inspector.DisableResponse;
import org.hildan.chrome.devtools.domains.inspector.EnableResponse;
import org.hildan.chrome.devtools.domains.inspector.events.InspectorEvent;
import org.hildan.chrome.devtools.protocol.ChromeDPSession;
import org.hildan.chrome.devtools.protocol.ExperimentalChromeApi;
import org.hildan.chrome.devtools.protocol.SessionSerializationKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ExperimentalChromeApi
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\fJ\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\fH\u0007J\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\fJ\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\fH\u0007J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\fJ\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\fH\u0007J\u000e\u0010\u0016\u001a\u00020\u0017H\u0086@\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u0019\u001a\u00020\u001aH\u0086@\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/hildan/chrome/devtools/domains/inspector/InspectorDomain;", "", "session", "Lorg/hildan/chrome/devtools/protocol/ChromeDPSession;", "<init>", "(Lorg/hildan/chrome/devtools/protocol/ChromeDPSession;)V", "deserializersByEventName", "", "", "Lkotlinx/serialization/DeserializationStrategy;", "Lorg/hildan/chrome/devtools/domains/inspector/events/InspectorEvent;", "events", "Lkotlinx/coroutines/flow/Flow;", "detachedEvents", "Lorg/hildan/chrome/devtools/domains/inspector/events/InspectorEvent$Detached;", "detached", "targetCrashedEvents", "Lorg/hildan/chrome/devtools/domains/inspector/events/InspectorEvent$TargetCrashed;", "targetCrashed", "targetReloadedAfterCrashEvents", "Lorg/hildan/chrome/devtools/domains/inspector/events/InspectorEvent$TargetReloadedAfterCrash;", "targetReloadedAfterCrash", "disable", "Lorg/hildan/chrome/devtools/domains/inspector/DisableResponse;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "enable", "Lorg/hildan/chrome/devtools/domains/inspector/EnableResponse;", "chrome-devtools-kotlin"})
@SourceDebugExtension(value={"SMAP\nInspectorDomain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InspectorDomain.kt\norg/hildan/chrome/devtools/domains/inspector/InspectorDomain\n+ 2 SessionSerialization.kt\norg/hildan/chrome/devtools/protocol/SessionSerializationKt\n*L\n1#1,108:1\n39#2,2:109\n39#2,2:111\n39#2,2:113\n18#2:115\n18#2:116\n*S KotlinDebug\n*F\n+ 1 InspectorDomain.kt\norg/hildan/chrome/devtools/domains/inspector/InspectorDomain\n*L\n60#1:109,2\n73#1:111,2\n86#1:113,2\n99#1:115\n106#1:116\n*E\n"})
public final class InspectorDomain {
    @NotNull
    private final ChromeDPSession session;
    @NotNull
    private final Map<String, DeserializationStrategy<InspectorEvent>> deserializersByEventName;

    public InspectorDomain(@NotNull ChromeDPSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.session = session2;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Inspector.detached", InspectorEvent.Detached.Companion.serializer()), TuplesKt.to((Object)"Inspector.targetCrashed", InspectorEvent.TargetCrashed.INSTANCE.serializer()), TuplesKt.to((Object)"Inspector.targetReloadedAfterCrash", InspectorEvent.TargetReloadedAfterCrash.INSTANCE.serializer())};
        this.deserializersByEventName = MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public final Flow<InspectorEvent> events() {
        return SessionSerializationKt.typedEvents(this.session, this.deserializersByEventName);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Flow<InspectorEvent.Detached> detachedEvents() {
        void $this$typedEvents$iv;
        ChromeDPSession chromeDPSession = this.session;
        String eventName$iv = "Inspector.detached";
        boolean $i$f$typedEvents = false;
        return SessionSerializationKt.typedEvents((ChromeDPSession)$this$typedEvents$iv, eventName$iv, (DeserializationStrategy)InspectorEvent.Detached.Companion.serializer());
    }

    @Deprecated(message="Events subscription methods were renamed with the -Events suffix.", replaceWith=@ReplaceWith(expression="detachedEvents()", imports={}))
    @NotNull
    public final Flow<InspectorEvent.Detached> detached() {
        return this.detachedEvents();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Flow<InspectorEvent.TargetCrashed> targetCrashedEvents() {
        void $this$typedEvents$iv;
        ChromeDPSession chromeDPSession = this.session;
        String eventName$iv = "Inspector.targetCrashed";
        boolean $i$f$typedEvents = false;
        return SessionSerializationKt.typedEvents((ChromeDPSession)$this$typedEvents$iv, eventName$iv, (DeserializationStrategy)InspectorEvent.TargetCrashed.INSTANCE.serializer());
    }

    @Deprecated(message="Events subscription methods were renamed with the -Events suffix.", replaceWith=@ReplaceWith(expression="targetCrashedEvents()", imports={}))
    @NotNull
    public final Flow<InspectorEvent.TargetCrashed> targetCrashed() {
        return this.targetCrashedEvents();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Flow<InspectorEvent.TargetReloadedAfterCrash> targetReloadedAfterCrashEvents() {
        void $this$typedEvents$iv;
        ChromeDPSession chromeDPSession = this.session;
        String eventName$iv = "Inspector.targetReloadedAfterCrash";
        boolean $i$f$typedEvents = false;
        return SessionSerializationKt.typedEvents((ChromeDPSession)$this$typedEvents$iv, eventName$iv, (DeserializationStrategy)InspectorEvent.TargetReloadedAfterCrash.INSTANCE.serializer());
    }

    @Deprecated(message="Events subscription methods were renamed with the -Events suffix.", replaceWith=@ReplaceWith(expression="targetReloadedAfterCrashEvents()", imports={}))
    @NotNull
    public final Flow<InspectorEvent.TargetReloadedAfterCrash> targetReloadedAfterCrash() {
        return this.targetReloadedAfterCrashEvents();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object disable(@NotNull Continuation<? super DisableResponse> $completion) {
        void methodName$iv;
        void $this$request$iv;
        ChromeDPSession chromeDPSession = this.session;
        String string2 = "Inspector.disable";
        Unit requestParams$iv = Unit.INSTANCE;
        boolean $i$f$request = false;
        return SessionSerializationKt.request((ChromeDPSession)$this$request$iv, (String)methodName$iv, requestParams$iv, (SerializationStrategy)UnitSerializer.INSTANCE, (DeserializationStrategy)DisableResponse.INSTANCE.serializer(), $completion);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object enable(@NotNull Continuation<? super EnableResponse> $completion) {
        void methodName$iv;
        void $this$request$iv;
        ChromeDPSession chromeDPSession = this.session;
        String string2 = "Inspector.enable";
        Unit requestParams$iv = Unit.INSTANCE;
        boolean $i$f$request = false;
        return SessionSerializationKt.request((ChromeDPSession)$this$request$iv, (String)methodName$iv, requestParams$iv, (SerializationStrategy)UnitSerializer.INSTANCE, (DeserializationStrategy)EnableResponse.INSTANCE.serializer(), $completion);
    }
}

