/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.chrome.devtools.domains.network;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.hildan.chrome.devtools.domains.network.IPAddressSpace;
import org.hildan.chrome.devtools.protocol.FCEnumSerializer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lorg/hildan/chrome/devtools/domains/network/IPAddressSpaceSerializer;", "Lorg/hildan/chrome/devtools/protocol/FCEnumSerializer;", "Lorg/hildan/chrome/devtools/domains/network/IPAddressSpace;", "<init>", "()V", "fromCode", "code", "", "codeOf", "value", "chrome-devtools-kotlin"})
final class IPAddressSpaceSerializer
extends FCEnumSerializer<IPAddressSpace> {
    @NotNull
    public static final IPAddressSpaceSerializer INSTANCE = new IPAddressSpaceSerializer();

    private IPAddressSpaceSerializer() {
        super(Reflection.getOrCreateKotlinClass(IPAddressSpace.class));
    }

    @Override
    @NotNull
    public IPAddressSpace fromCode(@NotNull String code) {
        IPAddressSpace iPAddressSpace;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        switch (code) {
            case "Local": {
                iPAddressSpace = IPAddressSpace.Local.INSTANCE;
                break;
            }
            case "Private": {
                iPAddressSpace = IPAddressSpace.Private.INSTANCE;
                break;
            }
            case "Public": {
                iPAddressSpace = IPAddressSpace.Public.INSTANCE;
                break;
            }
            case "Unknown": {
                iPAddressSpace = IPAddressSpace.Unknown.INSTANCE;
                break;
            }
            default: {
                iPAddressSpace = new IPAddressSpace.NotDefinedInProtocol(code);
            }
        }
        return iPAddressSpace;
    }

    @Override
    @NotNull
    public String codeOf(@NotNull IPAddressSpace value) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        IPAddressSpace iPAddressSpace = value;
        if (iPAddressSpace instanceof IPAddressSpace.Local) {
            string2 = "Local";
        } else if (iPAddressSpace instanceof IPAddressSpace.Private) {
            string2 = "Private";
        } else if (iPAddressSpace instanceof IPAddressSpace.Public) {
            string2 = "Public";
        } else if (iPAddressSpace instanceof IPAddressSpace.Unknown) {
            string2 = "Unknown";
        } else if (iPAddressSpace instanceof IPAddressSpace.NotDefinedInProtocol) {
            string2 = ((IPAddressSpace.NotDefinedInProtocol)value).getValue();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }
}

