/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.chrome.devtools.domains.storage;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.hildan.chrome.devtools.domains.storage.StorageType;
import org.hildan.chrome.devtools.protocol.FCEnumSerializer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lorg/hildan/chrome/devtools/domains/storage/StorageTypeSerializer;", "Lorg/hildan/chrome/devtools/protocol/FCEnumSerializer;", "Lorg/hildan/chrome/devtools/domains/storage/StorageType;", "<init>", "()V", "fromCode", "code", "", "codeOf", "value", "chrome-devtools-kotlin"})
final class StorageTypeSerializer
extends FCEnumSerializer<StorageType> {
    @NotNull
    public static final StorageTypeSerializer INSTANCE = new StorageTypeSerializer();

    private StorageTypeSerializer() {
        super(Reflection.getOrCreateKotlinClass(StorageType.class));
    }

    @Override
    @NotNull
    public StorageType fromCode(@NotNull String code) {
        StorageType storageType;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        switch (code) {
            case "cookies": {
                storageType = StorageType.cookies.INSTANCE;
                break;
            }
            case "file_systems": {
                storageType = StorageType.file_systems.INSTANCE;
                break;
            }
            case "indexeddb": {
                storageType = StorageType.indexeddb.INSTANCE;
                break;
            }
            case "local_storage": {
                storageType = StorageType.local_storage.INSTANCE;
                break;
            }
            case "shader_cache": {
                storageType = StorageType.shader_cache.INSTANCE;
                break;
            }
            case "websql": {
                storageType = StorageType.websql.INSTANCE;
                break;
            }
            case "service_workers": {
                storageType = StorageType.service_workers.INSTANCE;
                break;
            }
            case "cache_storage": {
                storageType = StorageType.cache_storage.INSTANCE;
                break;
            }
            case "interest_groups": {
                storageType = StorageType.interest_groups.INSTANCE;
                break;
            }
            case "shared_storage": {
                storageType = StorageType.shared_storage.INSTANCE;
                break;
            }
            case "storage_buckets": {
                storageType = StorageType.storage_buckets.INSTANCE;
                break;
            }
            case "all": {
                storageType = StorageType.all.INSTANCE;
                break;
            }
            case "other": {
                storageType = StorageType.other.INSTANCE;
                break;
            }
            default: {
                storageType = new StorageType.NotDefinedInProtocol(code);
            }
        }
        return storageType;
    }

    @Override
    @NotNull
    public String codeOf(@NotNull StorageType value) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        StorageType storageType = value;
        if (storageType instanceof StorageType.cookies) {
            string2 = "cookies";
        } else if (storageType instanceof StorageType.file_systems) {
            string2 = "file_systems";
        } else if (storageType instanceof StorageType.indexeddb) {
            string2 = "indexeddb";
        } else if (storageType instanceof StorageType.local_storage) {
            string2 = "local_storage";
        } else if (storageType instanceof StorageType.shader_cache) {
            string2 = "shader_cache";
        } else if (storageType instanceof StorageType.websql) {
            string2 = "websql";
        } else if (storageType instanceof StorageType.service_workers) {
            string2 = "service_workers";
        } else if (storageType instanceof StorageType.cache_storage) {
            string2 = "cache_storage";
        } else if (storageType instanceof StorageType.interest_groups) {
            string2 = "interest_groups";
        } else if (storageType instanceof StorageType.shared_storage) {
            string2 = "shared_storage";
        } else if (storageType instanceof StorageType.storage_buckets) {
            string2 = "storage_buckets";
        } else if (storageType instanceof StorageType.all) {
            string2 = "all";
        } else if (storageType instanceof StorageType.other) {
            string2 = "other";
        } else if (storageType instanceof StorageType.NotDefinedInProtocol) {
            string2 = ((StorageType.NotDefinedInProtocol)value).getValue();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }
}

