/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.chrome.devtools.domains.target;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.hildan.chrome.devtools.domains.target.WindowState;
import org.hildan.chrome.devtools.protocol.FCEnumSerializer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lorg/hildan/chrome/devtools/domains/target/WindowStateSerializer;", "Lorg/hildan/chrome/devtools/protocol/FCEnumSerializer;", "Lorg/hildan/chrome/devtools/domains/target/WindowState;", "<init>", "()V", "fromCode", "code", "", "codeOf", "value", "chrome-devtools-kotlin"})
final class WindowStateSerializer
extends FCEnumSerializer<WindowState> {
    @NotNull
    public static final WindowStateSerializer INSTANCE = new WindowStateSerializer();

    private WindowStateSerializer() {
        super(Reflection.getOrCreateKotlinClass(WindowState.class));
    }

    @Override
    @NotNull
    public WindowState fromCode(@NotNull String code) {
        WindowState windowState;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        switch (code) {
            case "normal": {
                windowState = WindowState.normal.INSTANCE;
                break;
            }
            case "minimized": {
                windowState = WindowState.minimized.INSTANCE;
                break;
            }
            case "maximized": {
                windowState = WindowState.maximized.INSTANCE;
                break;
            }
            case "fullscreen": {
                windowState = WindowState.fullscreen.INSTANCE;
                break;
            }
            default: {
                windowState = new WindowState.NotDefinedInProtocol(code);
            }
        }
        return windowState;
    }

    @Override
    @NotNull
    public String codeOf(@NotNull WindowState value) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        WindowState windowState = value;
        if (windowState instanceof WindowState.normal) {
            string2 = "normal";
        } else if (windowState instanceof WindowState.minimized) {
            string2 = "minimized";
        } else if (windowState instanceof WindowState.maximized) {
            string2 = "maximized";
        } else if (windowState instanceof WindowState.fullscreen) {
            string2 = "fullscreen";
        } else if (windowState instanceof WindowState.NotDefinedInProtocol) {
            string2 = ((WindowState.NotDefinedInProtocol)value).getValue();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }
}

