/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.chrome.devtools.domains.tethering;

import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.Flow;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import org.hildan.chrome.devtools.domains.tethering.BindRequest;
import org.hildan.chrome.devtools.domains.tethering.BindResponse;
import org.hildan.chrome.devtools.domains.tethering.UnbindRequest;
import org.hildan.chrome.devtools.domains.tethering.UnbindResponse;
import org.hildan.chrome.devtools.domains.tethering.events.TetheringEvent;
import org.hildan.chrome.devtools.protocol.ChromeDPSession;
import org.hildan.chrome.devtools.protocol.ExperimentalChromeApi;
import org.hildan.chrome.devtools.protocol.SessionSerializationKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ExperimentalChromeApi
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\fJ\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\fH\u0007J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0086@\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0086@\u00a2\u0006\u0002\u0010\u0017J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u001aH\u0086@\u00a2\u0006\u0002\u0010\u001bJ\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0086@\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/hildan/chrome/devtools/domains/tethering/TetheringDomain;", "", "session", "Lorg/hildan/chrome/devtools/protocol/ChromeDPSession;", "<init>", "(Lorg/hildan/chrome/devtools/protocol/ChromeDPSession;)V", "deserializersByEventName", "", "", "Lkotlinx/serialization/DeserializationStrategy;", "Lorg/hildan/chrome/devtools/domains/tethering/events/TetheringEvent;", "events", "Lkotlinx/coroutines/flow/Flow;", "acceptedEvents", "Lorg/hildan/chrome/devtools/domains/tethering/events/TetheringEvent$Accepted;", "accepted", "bind", "Lorg/hildan/chrome/devtools/domains/tethering/BindResponse;", "input", "Lorg/hildan/chrome/devtools/domains/tethering/BindRequest;", "(Lorg/hildan/chrome/devtools/domains/tethering/BindRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "port", "", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "unbind", "Lorg/hildan/chrome/devtools/domains/tethering/UnbindResponse;", "Lorg/hildan/chrome/devtools/domains/tethering/UnbindRequest;", "(Lorg/hildan/chrome/devtools/domains/tethering/UnbindRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "chrome-devtools-kotlin"})
@SourceDebugExtension(value={"SMAP\nTetheringDomain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TetheringDomain.kt\norg/hildan/chrome/devtools/domains/tethering/TetheringDomain\n+ 2 SessionSerialization.kt\norg/hildan/chrome/devtools/protocol/SessionSerializationKt\n*L\n1#1,131:1\n39#2,2:132\n18#2:134\n18#2:135\n*S KotlinDebug\n*F\n+ 1 TetheringDomain.kt\norg/hildan/chrome/devtools/domains/tethering/TetheringDomain\n*L\n81#1:132,2\n96#1:134\n117#1:135\n*E\n"})
public final class TetheringDomain {
    @NotNull
    private final ChromeDPSession session;
    @NotNull
    private final Map<String, DeserializationStrategy<TetheringEvent>> deserializersByEventName;

    public TetheringDomain(@NotNull ChromeDPSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.session = session2;
        this.deserializersByEventName = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Tethering.accepted", TetheringEvent.Accepted.Companion.serializer()));
    }

    @NotNull
    public final Flow<TetheringEvent> events() {
        return SessionSerializationKt.typedEvents(this.session, this.deserializersByEventName);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Flow<TetheringEvent.Accepted> acceptedEvents() {
        void $this$typedEvents$iv;
        ChromeDPSession chromeDPSession = this.session;
        String eventName$iv = "Tethering.accepted";
        boolean $i$f$typedEvents = false;
        return SessionSerializationKt.typedEvents((ChromeDPSession)$this$typedEvents$iv, eventName$iv, (DeserializationStrategy)TetheringEvent.Accepted.Companion.serializer());
    }

    @Deprecated(message="Events subscription methods were renamed with the -Events suffix.", replaceWith=@ReplaceWith(expression="acceptedEvents()", imports={}))
    @NotNull
    public final Flow<TetheringEvent.Accepted> accepted() {
        return this.acceptedEvents();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object bind(@NotNull BindRequest input, @NotNull Continuation<? super BindResponse> $completion) {
        void $this$request$iv;
        ChromeDPSession chromeDPSession = this.session;
        String methodName$iv = "Tethering.bind";
        boolean $i$f$request = false;
        return SessionSerializationKt.request((ChromeDPSession)$this$request$iv, methodName$iv, input, (SerializationStrategy)BindRequest.Companion.serializer(), (DeserializationStrategy)BindResponse.INSTANCE.serializer(), $completion);
    }

    @Nullable
    public final Object bind(int port, @NotNull Continuation<? super BindResponse> $completion) {
        BindRequest input = new BindRequest(port);
        return this.bind(input, $completion);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object unbind(@NotNull UnbindRequest input, @NotNull Continuation<? super UnbindResponse> $completion) {
        void $this$request$iv;
        ChromeDPSession chromeDPSession = this.session;
        String methodName$iv = "Tethering.unbind";
        boolean $i$f$request = false;
        return SessionSerializationKt.request((ChromeDPSession)$this$request$iv, methodName$iv, input, (SerializationStrategy)UnbindRequest.Companion.serializer(), (DeserializationStrategy)UnbindResponse.INSTANCE.serializer(), $completion);
    }

    @Nullable
    public final Object unbind(int port, @NotNull Continuation<? super UnbindResponse> $completion) {
        UnbindRequest input = new UnbindRequest(port);
        return this.unbind(input, $completion);
    }
}

