/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.chrome.devtools.protocol;

import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import org.hildan.chrome.devtools.protocol.ChromeDPConnection;
import org.hildan.chrome.devtools.protocol.ChromeDPSession;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u000e\u0010\u0003\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005H\u0000\u001a(\u0010\b\u001a\u00020\u00042\u000e\u0010\u0003\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u00052\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002\"\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"withSession", "Lorg/hildan/chrome/devtools/protocol/ChromeDPSession;", "Lorg/hildan/chrome/devtools/protocol/ChromeDPConnection;", "sessionId", "", "Lorg/hildan/chrome/devtools/domains/target/SessionID;", "crashEventNames", "", "buildTargetCrashedMessage", "crashEventName", "payload", "Lkotlinx/serialization/json/JsonElement;", "chrome-devtools-kotlin"})
public final class ChromeDPSessionKt {
    @NotNull
    private static final Set<String> crashEventNames;

    @NotNull
    public static final ChromeDPSession withSession(@NotNull ChromeDPConnection $this$withSession, @Nullable String sessionId) {
        Intrinsics.checkNotNullParameter((Object)$this$withSession, (String)"<this>");
        return new ChromeDPSession($this$withSession, sessionId);
    }

    private static final String buildTargetCrashedMessage(String sessionId, String crashEventName, JsonElement payload) {
        String payloadText;
        Object object2;
        JsonElement jsonElement = payload;
        if (jsonElement instanceof JsonNull) {
            object2 = null;
        } else if (jsonElement instanceof JsonPrimitive) {
            object2 = ((JsonPrimitive)payload).isString() ? "\"" + ((JsonPrimitive)payload).getContent() + "\"" : ((JsonPrimitive)payload).getContent();
        } else if (jsonElement instanceof JsonObject) {
            object2 = ((JsonObject)payload).size() > 0 ? ((JsonObject)payload).toString() : null;
        } else if (jsonElement instanceof JsonArray) {
            object2 = ((JsonArray)payload).size() > 0 ? ((JsonArray)payload).toString() : null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String string2 = payloadText = object2;
        Object payloadInfo = string2 == null ? "without payload." : "with payload: " + string2;
        String eventInfo = "Received event '" + crashEventName + "' " + (String)payloadInfo;
        return sessionId == null ? "The browser target has crashed. " + eventInfo : "The target with session ID " + sessionId + " has crashed. " + eventInfo;
    }

    public static final /* synthetic */ Set access$getCrashEventNames$p() {
        return crashEventNames;
    }

    public static final /* synthetic */ String access$buildTargetCrashedMessage(String sessionId, String crashEventName, JsonElement payload) {
        return ChromeDPSessionKt.buildTargetCrashedMessage(sessionId, crashEventName, payload);
    }

    static {
        Object[] objectArray = new String[]{"Inspector.targetCrashed", "Target.targetCrashed"};
        crashEventNames = SetsKt.setOf((Object[])objectArray);
    }
}

