/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.chrome.devtools.domains.audits;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.hildan.chrome.devtools.domains.audits.InsightType;
import org.hildan.chrome.devtools.protocol.FCEnumSerializer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lorg/hildan/chrome/devtools/domains/audits/InsightTypeSerializer;", "Lorg/hildan/chrome/devtools/protocol/FCEnumSerializer;", "Lorg/hildan/chrome/devtools/domains/audits/InsightType;", "<init>", "()V", "fromCode", "code", "", "codeOf", "value", "chrome-devtools-kotlin"})
final class InsightTypeSerializer
extends FCEnumSerializer<InsightType> {
    @NotNull
    public static final InsightTypeSerializer INSTANCE = new InsightTypeSerializer();

    private InsightTypeSerializer() {
        super(Reflection.getOrCreateKotlinClass(InsightType.class));
    }

    @Override
    @NotNull
    public InsightType fromCode(@NotNull String code) {
        InsightType insightType;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        switch (code) {
            case "GitHubResource": {
                insightType = InsightType.GitHubResource.INSTANCE;
                break;
            }
            case "GracePeriod": {
                insightType = InsightType.GracePeriod.INSTANCE;
                break;
            }
            case "Heuristics": {
                insightType = InsightType.Heuristics.INSTANCE;
                break;
            }
            default: {
                insightType = new InsightType.NotDefinedInProtocol(code);
            }
        }
        return insightType;
    }

    @Override
    @NotNull
    public String codeOf(@NotNull InsightType value) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        InsightType insightType = value;
        if (insightType instanceof InsightType.GitHubResource) {
            string2 = "GitHubResource";
        } else if (insightType instanceof InsightType.GracePeriod) {
            string2 = "GracePeriod";
        } else if (insightType instanceof InsightType.Heuristics) {
            string2 = "Heuristics";
        } else if (insightType instanceof InsightType.NotDefinedInProtocol) {
            string2 = ((InsightType.NotDefinedInProtocol)value).getValue();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }
}

